/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.tlv.tags;

import chat.dim.tlv.Tag;
import chat.dim.type.ByteArray;
import chat.dim.type.Data;
import chat.dim.type.IntegerData;
import chat.dim.type.VarIntData;

public class VarTag
extends Data
implements Tag {
    public static final VarTag ZERO = VarTag.from((IntegerData)VarIntData.ZERO, (ByteArray)Data.ZERO);
    public final IntegerData length;
    public final ByteArray content;

    public VarTag(ByteArray data, IntegerData length, ByteArray content) {
        super(data);
        this.length = length;
        this.content = content;
        assert (content != null) : "Variable Tag error";
        assert (data.getSize() == length.getSize() + content.getSize()) : "VarTag error: " + data.getSize();
    }

    private static IntegerData getLength(ByteArray data) {
        return VarIntData.from((ByteArray)data);
    }

    private static ByteArray getContent(ByteArray data, IntegerData length) {
        int size;
        int offset = length.getSize();
        if (offset + (size = length.getIntValue()) > data.getSize()) {
            return null;
        }
        return data.slice(offset, offset + size);
    }

    public static VarTag from(VarTag tag) {
        return tag;
    }

    public static VarTag from(ByteArray data) {
        IntegerData length = VarTag.getLength(data);
        if (length == null) {
            return null;
        }
        ByteArray content = VarTag.getContent(data, length);
        if (content == null) {
            return null;
        }
        int size = length.getSize() + content.getSize();
        if (size < data.getSize()) {
            data = data.slice(0, size);
        }
        return new VarTag(data, length, content);
    }

    public static VarTag from(IntegerData length, ByteArray content) {
        if (length == null) {
            length = VarIntData.from((long)content.getSize());
        } else assert (length.getIntValue() == content.getSize()) : "VarTag error: " + length.getIntValue() + ", " + content.getSize();
        ByteArray data = length.concat(new ByteArray[]{content});
        return new VarTag(data, length, content);
    }

    public static Tag parse(ByteArray data) {
        return VarTag.from(data);
    }
}

