/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.tlv.tags;

import chat.dim.tlv.Tag;
import chat.dim.type.ByteArray;
import chat.dim.type.IntegerData;
import chat.dim.type.UInt32Data;

public class Tag32
extends UInt32Data
implements Tag {
    public static final Tag32 ZERO = Tag32.from(UInt32Data.ZERO);

    public Tag32(UInt32Data data) {
        super((ByteArray)data, data.value, data.endian);
    }

    public Tag32(ByteArray data, long value, IntegerData.Endian endian) {
        super(data, value, endian);
    }

    public static Tag32 from(Tag32 tag) {
        return tag;
    }

    public static Tag32 from(UInt32Data data) {
        return new Tag32((ByteArray)data, data.value, data.endian);
    }

    public static Tag32 from(ByteArray data) {
        if (data.getSize() < 4) {
            return null;
        }
        if (data.getSize() > 4) {
            data = data.slice(0, 4);
        }
        return new Tag32(IntegerData.getUInt32Data((ByteArray)data));
    }

    public static Tag32 from(int value) {
        return new Tag32(IntegerData.getUInt32Data((long)value));
    }

    public static Tag32 from(long value) {
        return new Tag32(IntegerData.getUInt32Data((long)value));
    }

    public static Tag32 from(Integer value) {
        return new Tag32(IntegerData.getUInt32Data((long)value.intValue()));
    }

    public static Tag32 from(Long value) {
        return new Tag32(IntegerData.getUInt32Data((long)value));
    }

    public static Tag parse(ByteArray data) {
        return Tag32.from(data);
    }
}

