/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.tlv.tags;

import chat.dim.tlv.Tag;
import chat.dim.type.ByteArray;
import chat.dim.type.IntegerData;
import chat.dim.type.UInt16Data;

public class Tag16
extends UInt16Data
implements Tag {
    public static final Tag16 ZERO = Tag16.from(UInt16Data.ZERO);

    public Tag16(UInt16Data data) {
        super((ByteArray)data, data.value, data.endian);
    }

    public Tag16(ByteArray data, int value, IntegerData.Endian endian) {
        super(data, value, endian);
    }

    public static Tag16 from(Tag16 tag) {
        return tag;
    }

    public static Tag16 from(UInt16Data data) {
        return new Tag16((ByteArray)data, data.value, data.endian);
    }

    public static Tag16 from(ByteArray data) {
        if (data.getSize() < 2) {
            return null;
        }
        if (data.getSize() > 2) {
            data = data.slice(0, 2);
        }
        return new Tag16(IntegerData.getUInt16Data((ByteArray)data));
    }

    public static Tag16 from(int value) {
        return new Tag16(IntegerData.getUInt16Data((int)value));
    }

    public static Tag16 from(Integer value) {
        return new Tag16(IntegerData.getUInt16Data((int)value));
    }

    public static Tag parse(ByteArray data) {
        return Tag16.from(data);
    }
}

