/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.tlv;

import chat.dim.tlv.Entry;
import chat.dim.tlv.Length;
import chat.dim.tlv.Tag;
import chat.dim.tlv.Value;
import chat.dim.type.ByteArray;
import chat.dim.type.Data;

public class Triad<T extends Tag, L extends Length, V extends Value>
extends Data
implements Entry<T, L, V> {
    public final T tag;
    public final L length;
    public final V value;

    public Triad(Entry<T, L, V> tlv) {
        super(tlv);
        this.tag = tlv.getTag();
        this.length = tlv.getLength();
        this.value = tlv.getValue();
    }

    public Triad(ByteArray data, T type, L length, V value) {
        super(data);
        this.tag = type;
        this.length = length;
        this.value = value;
    }

    @Override
    public T getTag() {
        return this.tag;
    }

    @Override
    public L getLength() {
        return this.length;
    }

    @Override
    public V getValue() {
        return this.value;
    }

    public String toString() {
        return "/* " + this.getClass().getSimpleName() + " */ " + this.tag + ": \"" + this.value + "\"";
    }
}

