/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.tlv;

import chat.dim.tlv.Entry;
import chat.dim.tlv.Length;
import chat.dim.tlv.Tag;
import chat.dim.tlv.Value;
import chat.dim.type.ByteArray;
import java.util.ArrayList;
import java.util.List;

public abstract class Parser<E extends Entry<T, L, V>, T extends Tag, L extends Length, V extends Value>
implements Entry.Parser<E, T, L, V> {
    protected abstract Tag.Parser<T> getTagParser();

    protected abstract Length.Parser<T, L> getLengthParser();

    protected abstract Value.Parser<T, L, V> getValueParser();

    protected abstract E createEntry(ByteArray var1, T var2, L var3, V var4);

    @Override
    public E parseEntry(ByteArray data) {
        int valueLength;
        T type = this.getTagParser().parseTag(data);
        if (type == null) {
            return null;
        }
        int offset = type.getSize();
        L length = this.getLengthParser().parseLength(data.slice(offset), type);
        if (length == null) {
            valueLength = data.getSize() - offset;
        } else {
            valueLength = length.getIntValue();
            offset += length.getSize();
        }
        V value = this.getValueParser().parseValue(data.slice(offset, offset + valueLength), type, length);
        if (value != null) {
            offset += value.getSize();
        }
        return this.createEntry(data.slice(0, offset), type, length, value);
    }

    @Override
    public List<E> parseEntries(ByteArray data) {
        E item;
        ArrayList<E> array = new ArrayList<E>();
        while (data.getSize() > 0 && (item = this.parseEntry(data)) != null) {
            array.add(item);
            assert (item.getSize() > 0) : "TLV triads error";
            data = data.slice(item.getSize());
        }
        return array;
    }
}

