/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun.valus;

import chat.dim.stun.valus.MappedAddressValue;
import chat.dim.tlv.Length;
import chat.dim.tlv.Tag;
import chat.dim.tlv.Value;
import chat.dim.type.ByteArray;
import chat.dim.type.Data;

public class XorMappedAddressValue
extends MappedAddressValue {
    public XorMappedAddressValue(ByteArray data, String ip, int port, byte family) {
        super(data, ip, port, family);
    }

    public static XorMappedAddressValue from(XorMappedAddressValue value) {
        return value;
    }

    public static XorMappedAddressValue create(MappedAddressValue value, ByteArray factor) {
        ByteArray data = XorMappedAddressValue.xor((ByteArray)value, factor);
        return new XorMappedAddressValue(data, value.ip, value.port, value.family);
    }

    public static XorMappedAddressValue create(ByteArray data, ByteArray factor) {
        MappedAddressValue value = MappedAddressValue.from(XorMappedAddressValue.xor(data, factor));
        if (value == null) {
            return null;
        }
        return new XorMappedAddressValue(data, value.ip, value.port, value.family);
    }

    public static XorMappedAddressValue create(String ip, int port, byte family, ByteArray factor) {
        return XorMappedAddressValue.create(MappedAddressValue.create(ip, port, family), factor);
    }

    public static XorMappedAddressValue create(String ip, int port, ByteArray factor) {
        return XorMappedAddressValue.create(MappedAddressValue.create(ip, port, (byte)1), factor);
    }

    public static Value parse(ByteArray data, Tag tag, Length length) {
        return XorMappedAddressValue.from(data);
    }

    private static ByteArray xor(ByteArray addressValue, ByteArray trans_id) {
        int addressLen = addressValue.getSize();
        int factorLen = trans_id.getSize();
        if (addressLen != 8 && addressLen != 20) {
            throw new ArrayIndexOutOfBoundsException("address length error: " + addressLen);
        }
        if (factorLen != 16) {
            throw new ArrayIndexOutOfBoundsException("factor should be the \"magic code\" + \"(96-bits) transaction ID\"");
        }
        byte[] address = addressValue.getBuffer();
        byte[] factor = trans_id.getBuffer();
        int addressOffset = addressValue.getOffset();
        int factorOffset = trans_id.getOffset();
        assert (address[addressOffset] == 0) : "address data error";
        byte[] array = new byte[addressLen];
        array[1] = address[addressOffset + 1];
        array[2] = (byte)(address[addressOffset + 2] ^ factor[factorOffset + 1]);
        array[3] = (byte)(address[addressOffset + 3] ^ factor[factorOffset]);
        int a_pos = addressLen - 1;
        int f_pos = 0;
        while (a_pos >= 4) {
            array[a_pos] = (byte)(address[addressOffset + a_pos] ^ factor[factorOffset + f_pos]);
            --a_pos;
            ++f_pos;
        }
        return new Data(array);
    }
}

