/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun.valus;

import chat.dim.tlv.Length;
import chat.dim.tlv.Tag;
import chat.dim.tlv.Value;
import chat.dim.tlv.values.StringValue;
import chat.dim.type.ByteArray;
import chat.dim.type.MutableData;
import java.nio.charset.Charset;

public class SoftwareValue
extends StringValue {
    public SoftwareValue(ByteArray data, String description) {
        super(data, description);
    }

    public static SoftwareValue from(SoftwareValue value) {
        return value;
    }

    public static SoftwareValue from(ByteArray data) {
        String string = new String(data.getBytes(), Charset.forName("UTF-8"));
        return new SoftwareValue(data, string.trim());
    }

    public static SoftwareValue from(String string) {
        return new SoftwareValue(SoftwareValue.getData(string), string);
    }

    public static Value parse(ByteArray data, Tag tag, Length length) {
        return SoftwareValue.from(data);
    }

    private static ByteArray getData(String description) {
        byte[] bytes = description.getBytes(Charset.forName("UTF-8"));
        int length = bytes.length;
        int tail = length & 3;
        if (tail > 0) {
            length += 4 - tail;
        }
        MutableData data = new MutableData(length);
        data.append(bytes);
        if (tail > 0) {
            data.setByte(length - 1, (byte)0);
        }
        return data;
    }
}

