/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun.valus;

import chat.dim.tlv.Length;
import chat.dim.tlv.Tag;
import chat.dim.tlv.Value;
import chat.dim.tlv.values.RawValue;
import chat.dim.type.ByteArray;
import chat.dim.type.MutableData;

public class MappedAddressValue
extends RawValue {
    public static final byte FAMILY_IPV4 = 1;
    public static final byte FAMILY_IPV6 = 2;
    public final String ip;
    public final int port;
    public final byte family;

    public MappedAddressValue(ByteArray data, String ip, int port, byte family) {
        super(data);
        this.ip = ip;
        this.port = port;
        this.family = family;
    }

    public String toString() {
        return "\"" + this.ip + ":" + this.port + "\"";
    }

    public static MappedAddressValue from(MappedAddressValue value) {
        return value;
    }

    public static MappedAddressValue from(ByteArray data) {
        if (data.getByte(0) != 0) {
            return null;
        }
        byte family = data.getByte(1);
        if (family == 1 && data.getSize() == 8) {
            int port = (data.getByte(2) & 0xFF) << 8 | data.getByte(3) & 0xFF;
            String ip = MappedAddressValue.dataToIPv4(data.slice(4));
            return new MappedAddressValue(data, ip, port, family);
        }
        return null;
    }

    public static MappedAddressValue create(String ip, int port, byte family) {
        ByteArray data = MappedAddressValue.getData(ip, port, family);
        return new MappedAddressValue(data, ip, port, family);
    }

    public static MappedAddressValue create(String ip, int port) {
        ByteArray data = MappedAddressValue.getData(ip, port, (byte)1);
        return new MappedAddressValue(data, ip, port, 1);
    }

    public static Value parse(ByteArray data, Tag tag, Length length) {
        return MappedAddressValue.from(data);
    }

    private static ByteArray getData(String ip, int port, byte family) {
        ByteArray address = null;
        if (family == 1) {
            address = MappedAddressValue.dataFromIPv4(ip);
        }
        assert (address != null) : "failed to convert IP: " + ip + ", " + family;
        MutableData data = new MutableData(8);
        data.append((byte)0);
        data.append(family);
        data.append((byte)((port & 0xFF00) >> 8));
        data.append((byte)(port & 0xFF));
        data.append(address);
        return data;
    }

    private static ByteArray dataFromIPv4(String ip) {
        String[] array = ip.split("\\.");
        if (array.length != 4) {
            throw new IndexOutOfBoundsException("IP error: " + ip);
        }
        MutableData address = new MutableData(4);
        for (int index = 0; index < 4; ++index) {
            address.append((byte)Integer.parseInt(array[index]));
        }
        return address;
    }

    private static String dataToIPv4(ByteArray address) {
        if (address.getSize() != 4) {
            throw new IndexOutOfBoundsException("address error: " + address);
        }
        String[] array = new String[4];
        for (int index = 0; index < 4; ++index) {
            array[index] = String.valueOf(address.getByte(index) & 0xFF);
        }
        return array[0] + "." + array[1] + "." + array[2] + "." + array[3];
    }
}

