/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun.valus;

import chat.dim.tlv.Length;
import chat.dim.tlv.Tag;
import chat.dim.tlv.Value;
import chat.dim.tlv.values.Value32;
import chat.dim.type.ByteArray;
import chat.dim.type.IntegerData;
import chat.dim.type.UInt32Data;
import java.util.HashMap;
import java.util.Map;

public class ChangeRequestValue
extends Value32 {
    private final String name;
    private static final Map<Integer, ChangeRequestValue> s_values = new HashMap<Integer, ChangeRequestValue>();
    public static final ChangeRequestValue ChangeIP = ChangeRequestValue.create(4, "ChangeIP");
    public static final ChangeRequestValue ChangePort = ChangeRequestValue.create(2, "ChangePort");
    public static final ChangeRequestValue ChangeIPAndPort = ChangeRequestValue.create(6, "ChangeIPAndPort");

    public ChangeRequestValue(UInt32Data data, String name) {
        super(data);
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static ChangeRequestValue from(ChangeRequestValue value) {
        return value;
    }

    public static ChangeRequestValue from(UInt32Data data) {
        return ChangeRequestValue.get(data.getIntValue());
    }

    public static ChangeRequestValue from(ByteArray data) {
        if (data.getSize() < 4) {
            return null;
        }
        return ChangeRequestValue.get(IntegerData.getInt32Value((ByteArray)data));
    }

    public static ChangeRequestValue from(int value) {
        return ChangeRequestValue.get(value);
    }

    public static synchronized ChangeRequestValue get(int value) {
        ChangeRequestValue crv = s_values.get(value);
        if (crv == null) {
            crv = ChangeRequestValue.create(value, "ChangeRequestValue-" + value);
        }
        return crv;
    }

    public static Value parse(ByteArray data, Tag tag, Length length) {
        return ChangeRequestValue.from(data);
    }

    private static ChangeRequestValue create(int value, String name) {
        UInt32Data data = IntegerData.getUInt32Data((long)value);
        ChangeRequestValue crv = new ChangeRequestValue(data, name);
        s_values.put(value, crv);
        return crv;
    }
}

