/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun.protocol;

import chat.dim.stun.protocol.Header;
import chat.dim.stun.protocol.MessageLength;
import chat.dim.stun.protocol.MessageType;
import chat.dim.stun.protocol.TransactionID;
import chat.dim.type.ByteArray;
import chat.dim.type.Data;

public class Package
extends Data {
    public final Header head;
    public final ByteArray body;

    public Package(ByteArray data, Header head, ByteArray body) {
        super(data);
        this.head = head;
        this.body = body;
    }

    public static Package create(MessageType type, TransactionID sn, ByteArray body) {
        MessageLength length;
        if (body == null) {
            body = Data.ZERO;
            length = MessageLength.ZERO;
        } else {
            length = MessageLength.from(body.getSize());
        }
        Header head = sn == null ? Header.create(type, length) : Header.create(type, length, sn);
        ByteArray data = head.concat(new ByteArray[]{body});
        return new Package(data, head, body);
    }

    public static Package parse(ByteArray data) {
        Header head = Header.parse(data);
        if (head == null) {
            return null;
        }
        int packLen = head.getSize() + head.msgLength.getIntValue();
        int dataLen = data.getSize();
        if (dataLen < packLen) {
            return null;
        }
        if (dataLen > packLen) {
            data = data.slice(0, packLen);
        }
        ByteArray body = data.slice(head.getSize());
        return new Package(data, head, body);
    }
}

