/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun.protocol;

import chat.dim.type.ByteArray;
import chat.dim.type.IntegerData;
import chat.dim.type.UInt16Data;
import java.util.HashMap;
import java.util.Map;

public class MessageType
extends UInt16Data {
    private final String name;
    private static final Map<Integer, MessageType> s_types = new HashMap<Integer, MessageType>();
    public static final MessageType BindRequest = MessageType.create(1, "Bind Request");
    public static final MessageType BindResponse = MessageType.create(257, "Bind Response");
    public static final MessageType BindErrorResponse = MessageType.create(273, "Bind Error Response");
    public static final MessageType SharedSecretRequest = MessageType.create(2, "Shared Secret Request");
    public static final MessageType SharedSecretResponse = MessageType.create(258, "Shared Secret Response");
    public static final MessageType SharedSecretErrorResponse = MessageType.create(274, "Shared Secret Error Response");

    public MessageType(UInt16Data data, String name) {
        super((ByteArray)data, data.value, data.endian);
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static MessageType parse(ByteArray data) {
        if (data.getSize() < 2 || (data.getByte(0) & 0xC0) != 0) {
            return null;
        }
        if (data.getSize() > 2) {
            data = data.slice(0, 2);
        }
        return MessageType.get(IntegerData.getUInt16Data((ByteArray)data));
    }

    private static synchronized MessageType get(UInt16Data data) {
        MessageType type = s_types.get(data.value);
        if (type == null) {
            type = MessageType.create(data, "MsgType-" + Integer.toHexString(data.value));
        }
        return type;
    }

    private static MessageType create(UInt16Data data, String name) {
        MessageType type = new MessageType(data, name);
        s_types.put(data.value, type);
        return type;
    }

    public static synchronized MessageType create(int value, String name) {
        UInt16Data data = IntegerData.getUInt16Data((int)value);
        return MessageType.create(data, name);
    }
}

