/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun.protocol;

import chat.dim.stun.protocol.MessageLength;
import chat.dim.stun.protocol.MessageType;
import chat.dim.stun.protocol.TransactionID;
import chat.dim.type.ByteArray;
import chat.dim.type.Data;
import chat.dim.type.MutableData;

public class Header
extends Data {
    public final MessageType type;
    public final MessageLength msgLength;
    public final TransactionID sn;

    public Header(ByteArray data, MessageType type, MessageLength length, TransactionID sn) {
        super(data);
        this.type = type;
        this.msgLength = length;
        this.sn = sn;
    }

    public static Header create(MessageType type, MessageLength length) {
        return Header.create(type, length, new TransactionID());
    }

    public static Header create(MessageType type, MessageLength length, TransactionID sn) {
        MutableData data = new MutableData(type.getSize() + length.getSize() + sn.getSize());
        data.append((ByteArray)type);
        data.append((ByteArray)length);
        data.append((ByteArray)sn);
        return new Header((ByteArray)data, type, length, sn);
    }

    public static Header parse(ByteArray data) {
        MessageType type = MessageType.parse(data);
        if (type == null) {
            return null;
        }
        int pos = type.getSize();
        MessageLength len = MessageLength.parse(data.slice(pos));
        if (len == null) {
            return null;
        }
        TransactionID sn = TransactionID.parse(data.slice(pos += len.getSize()));
        if (sn == null) {
            return null;
        }
        assert ((pos += sn.getSize()) == 20) : "header length error: " + pos;
        if (data.getSize() > pos) {
            data = data.slice(0, pos);
        }
        return new Header(data, type, len, sn);
    }
}

