/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun.attributes;

import chat.dim.stun.attributes.AttributeParser;
import chat.dim.stun.attributes.ValueParser;
import chat.dim.stun.valus.ChangeRequestValue;
import chat.dim.stun.valus.ChangedAddressValue;
import chat.dim.stun.valus.MappedAddressValue;
import chat.dim.stun.valus.ResponseAddressValue;
import chat.dim.stun.valus.SoftwareValue;
import chat.dim.stun.valus.SourceAddressValue;
import chat.dim.tlv.tags.Tag16;
import chat.dim.type.ByteArray;
import chat.dim.type.IntegerData;
import chat.dim.type.UInt16Data;
import java.util.HashMap;
import java.util.Map;

public class AttributeType
extends Tag16 {
    public final String name;
    private static final Map<Integer, AttributeType> s_types = new HashMap<Integer, AttributeType>();
    public static final AttributeType MAPPED_ADDRESS = AttributeType.create(1, "MAPPED-ADDRESS");
    public static final AttributeType RESPONSE_ADDRESS = AttributeType.create(2, "RESPONSE-ADDRESS");
    public static final AttributeType CHANGE_REQUEST = AttributeType.create(3, "CHANGE-REQUEST");
    public static final AttributeType SOURCE_ADDRESS = AttributeType.create(4, "SOURCE-ADDRESS");
    public static final AttributeType CHANGED_ADDRESS = AttributeType.create(5, "CHANGED-ADDRESS");
    public static final AttributeType USERNAME = AttributeType.create(6, "USERNAME");
    public static final AttributeType PASSWORD = AttributeType.create(7, "PASSWORD");
    public static final AttributeType MESSAGE_INTEGRITY = AttributeType.create(8, "MESSAGE-INTEGRITY");
    public static final AttributeType ERROR_CODE = AttributeType.create(9, "ERROR-CODE");
    public static final AttributeType UNKNOWN_ATTRIBUTES = AttributeType.create(10, "UNKNOWN-ATTRIBUTES");
    public static final AttributeType REFLECTED_FROM = AttributeType.create(11, "REFLECTED-FROM");
    public static final AttributeType REALM = AttributeType.create(20, "REALM");
    public static final AttributeType NONCE = AttributeType.create(21, "NONCE");
    public static final AttributeType XOR_MAPPED_ADDRESS = AttributeType.create(32, "XOR-MAPPED-ADDRESS(0020)");
    public static final AttributeType XOR_MAPPED_ADDRESS_8020 = AttributeType.create(32800, "XOR-MAPPED-ADDRESS(8020)");
    public static final AttributeType XOR_ONLY = AttributeType.create(32801, "XOR-ONLY");
    public static final AttributeType SOFTWARE = AttributeType.create(32802, "SOFTWARE");
    public static final AttributeType ALTERNATE_SERVER = AttributeType.create(32803, "ALTERNATE-SERVER");
    public static final AttributeType FINGERPRINT = AttributeType.create(32808, "FINGERPRINT");

    public AttributeType(UInt16Data data, String name) {
        super((ByteArray)data, data.value, data.endian);
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static AttributeType from(AttributeType type) {
        return type;
    }

    public static AttributeType from(UInt16Data data) {
        return AttributeType.get(data);
    }

    public static AttributeType from(ByteArray data) {
        if (data.getSize() < 2) {
            return null;
        }
        if (data.getSize() > 2) {
            data = data.slice(0, 2);
        }
        return AttributeType.get(IntegerData.getUInt16Data((ByteArray)data));
    }

    public static AttributeType parse(ByteArray data) {
        return AttributeType.from(data);
    }

    private static synchronized AttributeType get(UInt16Data data) {
        AttributeType type = s_types.get(data.value);
        if (type == null) {
            type = AttributeType.create(data, "Attribute-" + Integer.toHexString(data.value));
        }
        return type;
    }

    private static AttributeType create(UInt16Data data, String name) {
        AttributeType type = new AttributeType(data, name);
        s_types.put(data.value, type);
        return type;
    }

    public static synchronized AttributeType create(int value, String name) {
        UInt16Data data = IntegerData.getUInt16Data((int)value);
        return AttributeType.create(data, name);
    }

    public static void register(AttributeType type, ValueParser parser) {
        AttributeParser.register(type.name, parser);
    }

    static {
        AttributeType.register(MAPPED_ADDRESS, MappedAddressValue::parse);
        AttributeType.register(RESPONSE_ADDRESS, ResponseAddressValue::parse);
        AttributeType.register(CHANGE_REQUEST, ChangeRequestValue::parse);
        AttributeType.register(SOURCE_ADDRESS, SourceAddressValue::parse);
        AttributeType.register(CHANGED_ADDRESS, ChangedAddressValue::parse);
        AttributeType.register(SOFTWARE, SoftwareValue::parse);
    }
}

