/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun.attributes;

import chat.dim.stun.attributes.Attribute;
import chat.dim.stun.attributes.AttributeType;
import chat.dim.stun.attributes.LengthParser;
import chat.dim.stun.attributes.TypeParser;
import chat.dim.stun.attributes.ValueParser;
import chat.dim.tlv.Length;
import chat.dim.tlv.Parser;
import chat.dim.tlv.Tag;
import chat.dim.tlv.Value;
import chat.dim.tlv.lengths.Length16;
import chat.dim.tlv.values.RawValue;
import chat.dim.type.ByteArray;
import java.util.HashMap;
import java.util.Map;

public class AttributeParser
extends Parser<Attribute, AttributeType, Length16, Value>
implements TypeParser,
LengthParser,
ValueParser {
    private static final Map<String, ValueParser> valueParsers = new HashMap<String, ValueParser>();

    protected TypeParser getTagParser() {
        return this;
    }

    protected LengthParser getLengthParser() {
        return this;
    }

    protected ValueParser getValueParser() {
        return this;
    }

    public AttributeType parseTag(ByteArray data) {
        return AttributeType.from(data);
    }

    public Length16 parseLength(ByteArray data, AttributeType type) {
        return Length16.from((ByteArray)data);
    }

    public Value parseValue(ByteArray data, AttributeType type, Length16 length) {
        ValueParser parser = valueParsers.get(type.name);
        if (parser == null) {
            return RawValue.from((ByteArray)data);
        }
        return parser.parseValue(data, (Tag)type, (Length)length);
    }

    protected Attribute createEntry(ByteArray data, AttributeType type, Length16 length, Value value) {
        return new Attribute(data, type, length, value);
    }

    public static void register(String type, ValueParser parser) {
        if (parser == null) {
            valueParsers.remove(type);
        } else {
            valueParsers.put(type, parser);
        }
    }
}

