/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun.attributes;

import chat.dim.stun.attributes.AttributeParser;
import chat.dim.stun.attributes.AttributeType;
import chat.dim.tlv.Entry;
import chat.dim.tlv.Length;
import chat.dim.tlv.Tag;
import chat.dim.tlv.Triad;
import chat.dim.tlv.Value;
import chat.dim.tlv.lengths.Length16;
import chat.dim.tlv.values.RawValue;
import chat.dim.type.ByteArray;
import java.util.List;

public class Attribute
extends Triad<AttributeType, Length16, Value> {
    private static final AttributeParser parser = new AttributeParser();

    public Attribute(Entry<AttributeType, Length16, Value> tlv) {
        super(tlv);
    }

    public Attribute(ByteArray data, AttributeType type, Length16 length, Value value) {
        super(data, (Tag)type, (Length)length, value);
    }

    public static List<Attribute> parseList(ByteArray data) {
        return parser.parseEntries(data);
    }

    public static Attribute from(Attribute attribute) {
        return attribute;
    }

    public static Attribute from(Entry<AttributeType, Length16, Value> tlv) {
        return new Attribute(tlv);
    }

    public static Attribute create(AttributeType type, Value value) {
        return Attribute.create(type, null, value);
    }

    public static Attribute create(AttributeType tag, Length16 length, Value value) {
        if (value == null) {
            value = RawValue.ZERO;
            length = Length16.ZERO;
        } else if (length == null) {
            length = Length16.from((int)value.getSize());
        }
        ByteArray data = tag.concat(new ByteArray[]{length, value});
        return new Attribute(data, tag, length, value);
    }
}

