/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun;

import chat.dim.stun.Node;
import chat.dim.stun.attributes.Attribute;
import chat.dim.stun.attributes.AttributeType;
import chat.dim.stun.protocol.Header;
import chat.dim.stun.protocol.MessageType;
import chat.dim.stun.protocol.Package;
import chat.dim.stun.valus.ChangeRequestValue;
import chat.dim.stun.valus.ChangedAddressValue;
import chat.dim.stun.valus.MappedAddressValue;
import chat.dim.stun.valus.SoftwareValue;
import chat.dim.stun.valus.SourceAddressValue;
import chat.dim.stun.valus.XorMappedAddressValue;
import chat.dim.stun.valus.XorMappedAddressValue2;
import chat.dim.tlv.Value;
import chat.dim.type.ByteArray;
import chat.dim.type.MutableData;
import java.net.InetSocketAddress;
import java.util.HashMap;

public abstract class Server
extends Node {
    public final String software = "stun.dim.chat 0.1";
    public final InetSocketAddress changedAddress;
    public final InetSocketAddress neighbour;
    public final int changePort;

    public Server(InetSocketAddress sourceAddress, int changePort, InetSocketAddress changedAddress, InetSocketAddress neighbour) {
        super(sourceAddress);
        this.changePort = changePort;
        this.changedAddress = changedAddress;
        this.neighbour = neighbour;
    }

    private boolean redirect(Header head, InetSocketAddress clientAddress) {
        MappedAddressValue value = MappedAddressValue.create(clientAddress.getHostString(), clientAddress.getPort());
        Attribute attribute = Attribute.create(AttributeType.MAPPED_ADDRESS, (Value)value);
        Package pack = Package.create(head.type, head.sn, (ByteArray)attribute);
        assert (this.neighbour != null) : "neighbour address not set yet";
        int res = this.send(pack.getBytes(), this.sourceAddress, this.neighbour);
        return res != -1;
    }

    private boolean respond(Header head, InetSocketAddress clientAddress, int localPort) {
        String remoteIP = clientAddress.getHostString();
        int remotePort = clientAddress.getPort();
        assert (this.sourceAddress != null) : "source address not set yet";
        String localIP = this.sourceAddress.getAddress().getHostAddress();
        assert (localPort > 0) : "local port error";
        assert (this.changedAddress != null) : "changed address not set yet";
        String changedIP = this.changedAddress.getHostString();
        int changedPort = this.changedAddress.getPort();
        Object value = MappedAddressValue.create(remoteIP, remotePort);
        Attribute data1 = Attribute.create(AttributeType.MAPPED_ADDRESS, (Value)value);
        value = XorMappedAddressValue.create(remoteIP, remotePort, (ByteArray)head.sn);
        Attribute data4 = Attribute.create(AttributeType.XOR_MAPPED_ADDRESS, (Value)value);
        value = XorMappedAddressValue2.create(remoteIP, remotePort, (ByteArray)head.sn);
        Attribute data5 = Attribute.create(AttributeType.XOR_MAPPED_ADDRESS_8020, (Value)value);
        value = SourceAddressValue.create(localIP, localPort);
        Attribute data2 = Attribute.create(AttributeType.SOURCE_ADDRESS, (Value)value);
        value = ChangedAddressValue.create(changedIP, changedPort);
        Attribute data3 = Attribute.create(AttributeType.CHANGED_ADDRESS, (Value)value);
        value = SoftwareValue.from("stun.dim.chat 0.1");
        Attribute data6 = Attribute.create(AttributeType.SOFTWARE, (Value)value);
        MutableData body = new MutableData(data1.getSize() + data2.getSize() + data3.getSize() + data4.getSize() + data5.getSize() + data6.getSize());
        body.append((ByteArray)data1);
        body.append((ByteArray)data2);
        body.append((ByteArray)data3);
        body.append((ByteArray)data4);
        body.append((ByteArray)data5);
        body.append((ByteArray)data6);
        Package pack = Package.create(MessageType.BindResponse, head.sn, (ByteArray)body);
        int res = this.send(pack.getBytes(), new InetSocketAddress(localIP, localPort), clientAddress);
        return res != -1;
    }

    public boolean handle(ByteArray data, InetSocketAddress clientAddress) {
        MappedAddressValue mappedAddress;
        HashMap<String, Object> context = new HashMap<String, Object>();
        boolean ok = this.parseData(data, context);
        Header head = (Header)((Object)context.get("head"));
        if (!ok || head == null || !head.type.equals((ByteArray)MessageType.BindRequest)) {
            return false;
        }
        this.info("received message type: " + (Object)((Object)head.type));
        ChangeRequestValue changeRequest = (ChangeRequestValue)((Object)context.get("CHANGE-REQUEST"));
        if (changeRequest != null) {
            if (changeRequest.equals((ByteArray)ChangeRequestValue.ChangeIPAndPort)) {
                return this.redirect(head, clientAddress);
            }
            if (changeRequest.equals((ByteArray)ChangeRequestValue.ChangePort)) {
                return this.respond(head, clientAddress, this.changePort);
            }
        }
        if ((mappedAddress = (MappedAddressValue)((Object)context.get("MAPPED-ADDRESS"))) == null) {
            int localPort = this.sourceAddress.getPort();
            return this.respond(head, clientAddress, localPort);
        }
        clientAddress = new InetSocketAddress(mappedAddress.ip, mappedAddress.port);
        return this.respond(head, clientAddress, this.changePort);
    }
}

