/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun;

import chat.dim.stun.attributes.Attribute;
import chat.dim.stun.attributes.AttributeType;
import chat.dim.stun.protocol.Package;
import chat.dim.stun.valus.ChangeRequestValue;
import chat.dim.stun.valus.ChangedAddressValue;
import chat.dim.stun.valus.MappedAddressValue;
import chat.dim.stun.valus.SoftwareValue;
import chat.dim.stun.valus.SourceAddressValue;
import chat.dim.stun.valus.XorMappedAddressValue;
import chat.dim.stun.valus.XorMappedAddressValue2;
import chat.dim.tlv.Value;
import chat.dim.tlv.lengths.Length16;
import chat.dim.type.ByteArray;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;

public abstract class Node {
    public final InetSocketAddress sourceAddress;

    public Node(InetSocketAddress address) {
        this.sourceAddress = address;
    }

    protected void info(String msg) {
    }

    public abstract int send(byte[] var1, SocketAddress var2, SocketAddress var3);

    protected Attribute parseAttribute(Attribute attribute, Map<String, Object> context) {
        AttributeType type = (AttributeType)attribute.tag;
        Object value = attribute.value;
        if (type.equals((ByteArray)AttributeType.CHANGE_REQUEST)) {
            assert (value instanceof ChangeRequestValue) : "change request value error: " + value;
            context.put("CHANGE-REQUEST", value);
        } else if (type.equals((ByteArray)AttributeType.MAPPED_ADDRESS)) {
            assert (value instanceof MappedAddressValue) : "mapped address value error: " + value;
            context.put("MAPPED-ADDRESS", value);
        } else if (type.equals((ByteArray)AttributeType.XOR_MAPPED_ADDRESS)) {
            if (!(value instanceof XorMappedAddressValue)) {
                ByteArray factor = (ByteArray)context.get("trans_id");
                value = XorMappedAddressValue.create((ByteArray)value, factor);
            }
            if (value != null) {
                context.put("MAPPED-ADDRESS", value);
            }
        } else if (type.equals((ByteArray)AttributeType.XOR_MAPPED_ADDRESS_8020)) {
            if (!(value instanceof XorMappedAddressValue2)) {
                ByteArray factor = (ByteArray)context.get("trans_id");
                value = XorMappedAddressValue2.create((ByteArray)value, factor);
            }
            if (value != null) {
                context.put("MAPPED-ADDRESS", value);
            }
        } else if (type.equals((ByteArray)AttributeType.CHANGED_ADDRESS)) {
            assert (value instanceof ChangedAddressValue) : "change address value error: " + value;
            context.put("CHANGED-ADDRESS", value);
        } else if (type.equals((ByteArray)AttributeType.SOURCE_ADDRESS)) {
            assert (value instanceof SourceAddressValue) : "source address value error: " + value;
            context.put("SOURCE-ADDRESS", value);
        } else if (type.equals((ByteArray)AttributeType.SOFTWARE)) {
            assert (value instanceof SoftwareValue) : "software value error: " + value;
            context.put("SOFTWARE", value);
        } else {
            this.info("unknown attribute type: " + (Object)((Object)type));
            return null;
        }
        this.info((Object)((Object)type) + ":\t" + value);
        return new Attribute((ByteArray)attribute, type, (Length16)attribute.length, (Value)value);
    }

    protected boolean parseData(ByteArray data, Map<String, Object> context) {
        Package pack = Package.parse(data);
        if (pack == null) {
            this.info("failed to parse package data: " + data);
            return false;
        }
        List<Attribute> attributes = Attribute.parseList(pack.body);
        for (Attribute item : attributes) {
            this.parseAttribute(item, context);
        }
        context.put("head", (Object)pack.head);
        return true;
    }
}

