/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.stun;

import chat.dim.stun.Node;
import chat.dim.stun.attributes.Attribute;
import chat.dim.stun.attributes.AttributeType;
import chat.dim.stun.protocol.Header;
import chat.dim.stun.protocol.MessageType;
import chat.dim.stun.protocol.Package;
import chat.dim.stun.protocol.TransactionID;
import chat.dim.stun.valus.ChangeRequestValue;
import chat.dim.stun.valus.ChangedAddressValue;
import chat.dim.stun.valus.MappedAddressValue;
import chat.dim.tlv.Value;
import chat.dim.type.ByteArray;
import chat.dim.type.Data;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;

public abstract class Client
extends Node {
    public int retries = 3;

    public Client(InetSocketAddress sourceAddress) {
        super(sourceAddress);
    }

    public abstract byte[] receive();

    private Map<String, Object> bindRequest(ByteArray body, SocketAddress serverAddress) {
        byte[] cargo;
        TransactionID sn;
        block4: {
            Package req = Package.create(MessageType.BindRequest, null, body);
            sn = req.head.sn;
            int count = 0;
            while (true) {
                int size;
                if ((size = this.send(req.getBytes(), this.sourceAddress, serverAddress)) == -1) {
                    return null;
                }
                cargo = this.receive();
                if (cargo != null) break block4;
                if (count >= this.retries) break;
                this.info("(" + ++count + "/" + this.retries + ") receive nothing");
            }
            return null;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("trans_id", (Object)sn);
        if (!this.parseData((ByteArray)new Data(cargo), context)) {
            return null;
        }
        Header head = (Header)((Object)context.get("head"));
        if (head == null || !head.type.equals((ByteArray)MessageType.BindResponse) || !head.sn.equals((ByteArray)sn)) {
            return null;
        }
        return context;
    }

    private Map<String, Object> test_1(SocketAddress serverAddress) {
        this.info("[Test 1] sending empty request ... " + serverAddress);
        return this.bindRequest((ByteArray)Data.ZERO, serverAddress);
    }

    private Map<String, Object> test_2(SocketAddress serverAddress) {
        this.info("[Test 2] sending ChangeIPAndPort request ... " + serverAddress);
        Attribute item = Attribute.create(AttributeType.CHANGE_REQUEST, (Value)ChangeRequestValue.ChangeIPAndPort);
        return this.bindRequest((ByteArray)item, serverAddress);
    }

    private Map<String, Object> test_3(SocketAddress serverAddress) {
        this.info("[Test 1] sending ChangePort request ... " + serverAddress);
        Attribute item = Attribute.create(AttributeType.CHANGE_REQUEST, (Value)ChangeRequestValue.ChangePort);
        return this.bindRequest((ByteArray)item, serverAddress);
    }

    public Map<String, Object> getNatType(SocketAddress serverAddress) {
        Map<String, Object> res1 = this.test_1(serverAddress);
        if (res1 == null) {
            res1 = new HashMap<String, Object>();
            res1.put("NAT", "UDP Blocked");
            return res1;
        }
        MappedAddressValue ma1 = (MappedAddressValue)((Object)res1.get("MAPPED-ADDRESS"));
        Map<String, Object> res2 = this.test_2(serverAddress);
        if (ma1 != null && ma1.port == this.sourceAddress.getPort() && ma1.ip.equals(this.sourceAddress.getHostString())) {
            if (res2 == null) {
                res1.put("NAT", "Symmetric UDP Firewall");
                return res1;
            }
            res2.put("NAT", "Open Internet");
            return res2;
        }
        if (res2 != null) {
            res2.put("NAT", "Full Cone NAT");
            return res2;
        }
        ChangedAddressValue ca1 = (ChangedAddressValue)((Object)res1.get("CHANGED-ADDRESS"));
        if (ca1 == null) {
            res1.put("NAT", "Changed-Address not found");
            return res1;
        }
        InetSocketAddress address = new InetSocketAddress(ca1.ip, ca1.port);
        Map<String, Object> res11 = this.test_1(address);
        if (res11 == null) {
            res1.put("NAT", "Change address failed");
            return res1;
        }
        MappedAddressValue ma11 = (MappedAddressValue)((Object)res11.get("MAPPED-ADDRESS"));
        if (ma11 == null || ma1 == null || ma11.port != ma1.port || !ma11.ip.equals(ma1.ip)) {
            res11.put("NAT", "Symmetric NAT");
            return res11;
        }
        Map<String, Object> res3 = this.test_3(serverAddress);
        if (res3 == null) {
            res11.put("NAT", "Port Restricted Cone NAT");
            return res11;
        }
        res3.put("NAT", "Restricted Cone NAT");
        return res3;
    }
}

