/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.type;

import chat.dim.type.ByteArray;
import chat.dim.type.Data;
import chat.dim.type.IntegerData;

public class VarIntData
extends Data
implements IntegerData {
    public final long value;
    public static final VarIntData ZERO = VarIntData.from(0L);

    public VarIntData(ByteArray data, long value) {
        super(data);
        this.value = value;
    }

    public VarIntData(byte[] bytes, int offset, int size, long value) {
        super(bytes, offset, size);
        this.value = value;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IntegerData) {
            return this.value == (long)((IntegerData)other).getIntValue();
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public int getIntValue() {
        return (int)this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    public static VarIntData from(VarIntData data) {
        return data;
    }

    public static VarIntData from(ByteArray data) {
        return VarIntData.parse(data.getBuffer(), data.getOffset(), data.getSize());
    }

    public static VarIntData from(byte[] bytes) {
        return VarIntData.parse(bytes, 0, bytes.length);
    }

    public static VarIntData from(byte[] bytes, int start) {
        return VarIntData.parse(bytes, start, bytes.length - start);
    }

    public static VarIntData from(long value) {
        byte[] buffer = new byte[10];
        int length = VarIntData.setValue(value, buffer, 0, 10);
        return new VarIntData(buffer, 0, length, value);
    }

    private static VarIntData parse(byte[] buffer, int offset, int size) {
        long value = 0L;
        int bits = 0;
        int pos = offset;
        int end = offset + size;
        int ch = -128;
        while ((ch & 0x80) != 0) {
            if (pos >= end) {
                return null;
            }
            ch = buffer[pos];
            value |= ((long)ch & 0x7FL) << bits;
            ++pos;
            bits += 7;
        }
        return new VarIntData(buffer, offset, pos - offset, value);
    }

    private static int setValue(long value, byte[] buffer, int offset, int length) {
        int pos = offset;
        while (value > 127L) {
            assert (pos < offset + length) : "out of range: [" + offset + ", " + length + ")";
            buffer[pos] = (byte)(value & 0x7FL | 0x80L);
            value >>= 7;
            ++pos;
        }
        buffer[pos] = (byte)(value & 0x7FL);
        return pos - offset + 1;
    }
}

