/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.type;

import chat.dim.type.ByteArray;
import chat.dim.type.Data;
import chat.dim.type.IntegerData;

public class UInt8Data
extends Data
implements IntegerData {
    public final int value;
    public static final UInt8Data ZERO = UInt8Data.from(0);

    public UInt8Data(ByteArray data) {
        super(data);
        assert (data.getSize() == 1) : "UInt8Data error: size=" + data.getSize();
        this.value = data.getByte(0) & 0xFF;
    }

    public UInt8Data(byte[] bytes, int offset) {
        super(bytes, offset, 1);
        assert (bytes.length >= offset + 1) : "UInt8Data error: offset=" + offset + ", length=" + bytes.length;
        this.value = bytes[offset] & 0xFF;
    }

    public UInt8Data(byte value) {
        super(new byte[1]);
        this.buffer[0] = value;
        this.value = value & 0xFF;
    }

    public UInt8Data(int value) {
        super(new byte[1]);
        this.buffer[0] = (byte)(value & 0xFF);
        this.value = value;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IntegerData) {
            return this.value == ((IntegerData)other).getIntValue();
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    @Override
    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    public byte getByteValue() {
        return (byte)(this.value & 0xFF);
    }

    public static UInt8Data from(UInt8Data data) {
        return data;
    }

    public static UInt8Data from(ByteArray data) {
        if (data.getSize() < 1) {
            return null;
        }
        if (data.getSize() > 1) {
            data = data.slice(0, 1);
        }
        return new UInt8Data(data);
    }

    public static UInt8Data from(byte[] bytes) {
        if (bytes.length < 1) {
            return null;
        }
        return new UInt8Data(bytes, 0);
    }

    public static UInt8Data from(byte[] bytes, int offset) {
        if (bytes.length < offset + 1) {
            return null;
        }
        return new UInt8Data(bytes, offset);
    }

    public static UInt8Data from(byte value) {
        return new UInt8Data(value);
    }

    public static UInt8Data from(int value) {
        return new UInt8Data(value);
    }
}

