/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.type;

import chat.dim.type.ByteArray;
import chat.dim.type.Data;
import chat.dim.type.IntegerData;

public class UInt32Data
extends Data
implements IntegerData {
    public final long value;
    public final IntegerData.Endian endian;
    public static final UInt32Data ZERO = UInt32Data.from(0L, IntegerData.Endian.BIG_ENDIAN);

    public UInt32Data(ByteArray data, long value, IntegerData.Endian endian) {
        super(data);
        this.value = value;
        this.endian = endian;
        assert (data.getSize() == 4) : "UInt32Data error: size=" + data.getSize();
    }

    public UInt32Data(byte[] bytes, int offset, long value, IntegerData.Endian endian) {
        super(bytes, offset, 4);
        this.value = value;
        this.endian = endian;
        assert (bytes.length >= offset + 4) : "UInt32Data error: offset=" + offset + ", length=" + bytes.length;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof IntegerData) {
            return this.value == ((IntegerData)other).getLongValue();
        }
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.value);
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public int getIntValue() {
        return (int)this.value;
    }

    @Override
    public long getLongValue() {
        return this.value;
    }

    public static UInt32Data from(UInt32Data data) {
        return data;
    }

    public static UInt32Data from(ByteArray data, IntegerData.Endian endian) {
        if (data.getSize() < 4) {
            return null;
        }
        if (data.getSize() > 4) {
            data = data.slice(0, 4);
        }
        long value = UInt32Data.getValue(data, endian);
        return new UInt32Data(data, value, endian);
    }

    public static UInt32Data from(byte[] bytes, IntegerData.Endian endian) {
        if (bytes.length < 4) {
            return null;
        }
        long value = UInt32Data.getValue(bytes, 0, endian);
        return new UInt32Data(bytes, 0, value, endian);
    }

    public static UInt32Data from(byte[] bytes, int offset, IntegerData.Endian endian) {
        if (bytes.length < offset + 4) {
            return null;
        }
        long value = UInt32Data.getValue(bytes, offset, endian);
        return new UInt32Data(bytes, offset, value, endian);
    }

    public static UInt32Data from(long value, IntegerData.Endian endian) {
        ByteArray data = UInt32Data.getData(value, endian);
        return new UInt32Data(data, value, endian);
    }

    private static long getValue(ByteArray data, IntegerData.Endian endian) {
        assert (data.getSize() == 4) : "UInt32Data error: size=" + data.getSize();
        return IntegerData.getValue(data, endian);
    }

    private static long getValue(byte[] bytes, int offset, IntegerData.Endian endian) {
        assert (bytes.length == offset + 4) : "UInt32Data error: offset=" + offset + ", length=" + bytes.length;
        return IntegerData.getValue(bytes, offset, 4, endian);
    }

    private static ByteArray getData(long value, IntegerData.Endian endian) {
        byte[] buffer = new byte[4];
        IntegerData.setValue(value, buffer, 0, 4, endian);
        return new Data(buffer);
    }
}

