/*
 * Decompiled with CFR 0.152.
 */
package chat.dim.type;

import chat.dim.type.ByteArray;
import chat.dim.type.MutableByteArray;
import chat.dim.type.UInt16Data;
import chat.dim.type.UInt32Data;

public interface IntegerData
extends ByteArray {
    public static final Helper helper;

    public int getIntValue();

    public long getLongValue();

    public static int getInt16Value(ByteArray data) {
        return (int)IntegerData.getValue(data, 0, 2, Endian.BIG_ENDIAN);
    }

    public static int getUInt16Value(ByteArray data) {
        return (int)IntegerData.getValue(data, 0, 2, Endian.BIG_ENDIAN);
    }

    public static int getInt16Value(ByteArray data, int start) {
        return (int)IntegerData.getValue(data, start, 2, Endian.BIG_ENDIAN);
    }

    public static int getUInt16Value(ByteArray data, int start) {
        return (int)IntegerData.getValue(data, start, 2, Endian.BIG_ENDIAN);
    }

    public static int getInt32Value(ByteArray data) {
        return (int)IntegerData.getValue(data, 0, 4, Endian.BIG_ENDIAN);
    }

    public static long getUInt32Value(ByteArray data) {
        return IntegerData.getValue(data, 0, 4, Endian.BIG_ENDIAN);
    }

    public static int getInt32Value(ByteArray data, int start) {
        return (int)IntegerData.getValue(data, start, 4, Endian.BIG_ENDIAN);
    }

    public static long getUInt32Value(ByteArray data, int start) {
        return IntegerData.getValue(data, start, 4, Endian.BIG_ENDIAN);
    }

    public static UInt16Data getUInt16Data(int value) {
        return UInt16Data.from(value, Endian.BIG_ENDIAN);
    }

    public static UInt16Data getUInt16Data(ByteArray data) {
        return UInt16Data.from(data, Endian.BIG_ENDIAN);
    }

    public static UInt16Data getUInt16Data(ByteArray data, int start) {
        return UInt16Data.from(data.slice(start), Endian.BIG_ENDIAN);
    }

    public static UInt32Data getUInt32Data(long value) {
        return UInt32Data.from(value, Endian.BIG_ENDIAN);
    }

    public static UInt32Data getUInt32Data(ByteArray data) {
        return UInt32Data.from(data, Endian.BIG_ENDIAN);
    }

    public static UInt32Data getUInt32Data(ByteArray data, int start) {
        return UInt32Data.from(data.slice(start), Endian.BIG_ENDIAN);
    }

    public static long getValue(byte[] buffer, int start, int size, Endian endian) {
        return helper.getValue(buffer, start, size, endian);
    }

    public static long getValue(ByteArray data, int start, int size, Endian endian) {
        if (!(2.$assertionsDisabled || 0 <= start && 0 < size && start + size <= data.getSize())) {
            throw new AssertionError((Object)("out of range: start=" + start + ", size=" + size + ", view length=" + data.getSize()));
        }
        return helper.getValue(data.getBuffer(), data.getOffset() + start, size, endian);
    }

    public static long getValue(ByteArray data, int size, Endian endian) {
        if (!(2.$assertionsDisabled || 0 < size && size <= data.getSize())) {
            throw new AssertionError((Object)("out of range: size=" + size + ", view length=" + data.getSize()));
        }
        return helper.getValue(data.getBuffer(), data.getOffset(), size, endian);
    }

    public static long getValue(ByteArray data, Endian endian) {
        if (!2.$assertionsDisabled && 0 >= data.getSize()) {
            throw new AssertionError((Object)"data empty");
        }
        return helper.getValue(data.getBuffer(), data.getOffset(), data.getSize(), endian);
    }

    public static void setValue(long value, byte[] buffer, int offset, int size, Endian endian) {
        helper.setValue(value, buffer, offset, size, endian);
    }

    public static void setValue(long value, MutableByteArray data, int start, int size, Endian endian) {
        data.setByte(start + size - 1, (byte)0);
        helper.setValue(value, data.getBuffer(), data.getOffset() + start, size, endian);
    }

    public static void setValue(long value, MutableByteArray data, int size, Endian endian) {
        data.setByte(size - 1, (byte)0);
        helper.setValue(value, data.getBuffer(), data.getOffset(), size, endian);
    }

    public static void setValue(long value, MutableByteArray data, Endian endian) {
        helper.setValue(value, data.getBuffer(), data.getOffset(), data.getSize(), endian);
    }

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
        helper = new Helper(){

            @Override
            public long getValue(byte[] buffer, int start, int size, Endian endian) {
                long result;
                block3: {
                    block2: {
                        result = 0L;
                        if (endian != Endian.LITTLE_ENDIAN) break block2;
                        for (int pos = start + size - 1; pos >= start; --pos) {
                            result = result << 8 | (long)(buffer[pos] & 0xFF);
                        }
                        break block3;
                    }
                    if (endian != Endian.BIG_ENDIAN) break block3;
                    int end = start + size;
                    for (int pos = start; pos < end; ++pos) {
                        result = result << 8 | (long)(buffer[pos] & 0xFF);
                    }
                }
                return result;
            }

            @Override
            public void setValue(long value, byte[] buffer, int offset, int size, Endian endian) {
                block3: {
                    block2: {
                        if (endian != Endian.LITTLE_ENDIAN) break block2;
                        int end = offset + size;
                        for (int pos = offset; pos < end; ++pos) {
                            buffer[pos] = (byte)(value & 0xFFL);
                            value >>= 8;
                        }
                        break block3;
                    }
                    if (endian != Endian.BIG_ENDIAN) break block3;
                    for (int pos = offset + size - 1; pos >= offset; --pos) {
                        buffer[pos] = (byte)(value & 0xFFL);
                        value >>= 8;
                    }
                }
            }
        };
    }

    public static interface Helper {
        public long getValue(byte[] var1, int var2, int var3, Endian var4);

        public void setValue(long var1, byte[] var3, int var4, int var5, Endian var6);
    }

    public static enum Endian {
        BIG_ENDIAN,
        LITTLE_ENDIAN;

    }
}

