/*
 * Decompiled with CFR 0.152.
 */
package ch.tutteli.atrium.reporting.translating;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0010\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J7\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lch/tutteli/atrium/reporting/translating/Locale;", "", "language", "", "country", "(Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "script", "variant", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCountry", "()Ljava/lang/String;", "getLanguage", "getScript", "getVariant", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "requireAtLeastOneAndOnlyLetters", "", "field", "name", "toString", "atrium-core-api-jvm"})
public final class Locale {
    @NotNull
    private final String language;
    @Nullable
    private final String script;
    @Nullable
    private final String country;
    @Nullable
    private final String variant;

    private final void requireAtLeastOneAndOnlyLetters(String field, String name) {
        Regex regex = new Regex("[a-zA-Z]+");
        CharSequence charSequence = field;
        boolean bl = regex.matches(charSequence);
        if (!bl) {
            String string = name + " has to match [a-zA-Z]+ was " + field;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("Locale(").append(this.language);
        if (this.script != null) {
            sb.append("-").append(this.script);
        }
        if (this.country != null) {
            sb.append("_").append(this.country);
        }
        if (this.variant != null) {
            sb.append("_").append(this.variant);
        }
        sb.append(")");
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public final String getLanguage() {
        return this.language;
    }

    @Nullable
    public final String getScript() {
        return this.script;
    }

    @Nullable
    public final String getCountry() {
        return this.country;
    }

    @Nullable
    public final String getVariant() {
        return this.variant;
    }

    public Locale(@NotNull String language, @Nullable String script, @Nullable String country, @Nullable String variant) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        this.language = language;
        this.script = script;
        this.country = country;
        this.variant = variant;
        this.requireAtLeastOneAndOnlyLetters(this.language, "language");
        if (this.script != null) {
            this.requireAtLeastOneAndOnlyLetters(this.script, "script");
        }
        if (this.country != null) {
            this.requireAtLeastOneAndOnlyLetters(this.country, "country");
        }
        if (this.variant != null) {
            boolean bl;
            CharSequence charSequence = this.variant;
            boolean bl2 = bl = !StringsKt.isBlank((CharSequence)charSequence);
            if (!bl) {
                String string = "variant cannot be blank - use `null` if you do not want to specify it";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    public Locale(@NotNull String language, @NotNull String country) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        Intrinsics.checkParameterIsNotNull((Object)country, (String)"country");
        this(language, null, country, null);
    }

    public Locale(@NotNull String language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        this(language, null, null, null);
    }

    @NotNull
    public final String component1() {
        return this.language;
    }

    @Nullable
    public final String component2() {
        return this.script;
    }

    @Nullable
    public final String component3() {
        return this.country;
    }

    @Nullable
    public final String component4() {
        return this.variant;
    }

    @NotNull
    public final Locale copy(@NotNull String language, @Nullable String script, @Nullable String country, @Nullable String variant) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        return new Locale(language, script, country, variant);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Locale copy$default(Locale locale, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = locale.language;
        }
        if ((n & 2) != 0) {
            string2 = locale.script;
        }
        if ((n & 4) != 0) {
            string3 = locale.country;
        }
        if ((n & 8) != 0) {
            string4 = locale.variant;
        }
        return locale.copy(string, string2, string3, string4);
    }

    public int hashCode() {
        String string = this.language;
        String string2 = this.script;
        String string3 = this.country;
        String string4 = this.variant;
        return (((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Locale)) break block3;
                Locale locale = (Locale)object;
                if (!Intrinsics.areEqual((Object)this.language, (Object)locale.language) || !Intrinsics.areEqual((Object)this.script, (Object)locale.script) || !Intrinsics.areEqual((Object)this.country, (Object)locale.country) || !Intrinsics.areEqual((Object)this.variant, (Object)locale.variant)) break block3;
            }
            return true;
        }
        return false;
    }
}

