/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.quicktime;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageOutputStream;
import javax.sound.sampled.AudioFormat;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Codec;
import org.monte.media.av.Format;
import org.monte.media.av.FormatKeys;
import org.monte.media.av.MovieWriter;
import org.monte.media.av.Registry;
import org.monte.media.av.codec.audio.AudioFormatKeys;
import org.monte.media.av.codec.video.VideoFormatKeys;
import org.monte.media.math.Rational;
import org.monte.media.quicktime.AbstractQuickTimeStream;
import org.monte.media.quicktime.DataAtomOutputStream;
import org.monte.media.quicktime.QuickTimeOutputStream;

public class QuickTimeWriter
extends QuickTimeOutputStream
implements MovieWriter {
    public static final Format QUICKTIME = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.FILE, FormatKeys.MimeTypeKey, "video/quicktime"});
    public static final Format VIDEO_RAW = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "raw ", VideoFormatKeys.CompressorNameKey, "NONE"});
    public static final Format VIDEO_ANIMATION = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "rle ", VideoFormatKeys.CompressorNameKey, "Animation"});
    public static final Format VIDEO_JPEG = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "jpeg", VideoFormatKeys.CompressorNameKey, "Photo - JPEG"});
    public static final Format VIDEO_PNG = new Format(new Object[]{FormatKeys.MediaTypeKey, FormatKeys.MediaType.VIDEO, FormatKeys.MimeTypeKey, "video/quicktime", FormatKeys.EncodingKey, "png ", VideoFormatKeys.CompressorNameKey, "PNG"});

    public QuickTimeWriter(File file) throws IOException {
        super(file);
    }

    public QuickTimeWriter(ImageOutputStream out) throws IOException {
        super(out);
    }

    @Override
    public Format getFileFormat() throws IOException {
        return QUICKTIME;
    }

    @Override
    public Format getFormat(int track) {
        return ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).format;
    }

    @Override
    public int addTrack(Format fmt) throws IOException {
        if (fmt.get(FormatKeys.MediaTypeKey) == FormatKeys.MediaType.VIDEO) {
            int t = this.addVideoTrack(fmt.get(FormatKeys.EncodingKey), fmt.get(VideoFormatKeys.CompressorNameKey, fmt.get(FormatKeys.EncodingKey)), Math.min(6000L, fmt.get(FormatKeys.FrameRateKey).getNumerator() * fmt.get(FormatKeys.FrameRateKey).getDenominator()), fmt.get(VideoFormatKeys.WidthKey), fmt.get(VideoFormatKeys.HeightKey), fmt.get(VideoFormatKeys.DepthKey), (int)fmt.get(FormatKeys.FrameRateKey).getDenominator());
            this.setCompressionQuality(t, fmt.get(VideoFormatKeys.QualityKey, Float.valueOf(1.0f)).floatValue());
            return t;
        }
        if (fmt.get(FormatKeys.MediaTypeKey) == FormatKeys.MediaType.AUDIO) {
            int sampleSizeInBits = fmt.get(AudioFormatKeys.SampleSizeInBitsKey, 16);
            ByteOrder bo = fmt.get(AudioFormatKeys.ByteOrderKey, ByteOrder.BIG_ENDIAN);
            boolean signed = fmt.get(AudioFormatKeys.SignedKey, true);
            String encoding = fmt.get(FormatKeys.EncodingKey, null);
            Rational frameRate = fmt.get(FormatKeys.FrameRateKey, fmt.get(AudioFormatKeys.SampleRateKey));
            int channels = fmt.get(AudioFormatKeys.ChannelsKey, 1);
            int frameSize = fmt.get(AudioFormatKeys.FrameSizeKey, (sampleSizeInBits + 7) / 8 * sampleSizeInBits);
            if (encoding == null || encoding.length() != 4) {
                encoding = signed ? (bo == ByteOrder.BIG_ENDIAN ? "twos" : "sowt") : "raw ";
            }
            return this.addAudioTrack(encoding, fmt.get(AudioFormatKeys.SampleRateKey).longValue(), fmt.get(AudioFormatKeys.SampleRateKey).doubleValue(), channels, sampleSizeInBits, false, fmt.get(AudioFormatKeys.SampleRateKey).divide(frameRate).intValue(), frameSize, signed, bo);
        }
        throw new IOException("Unsupported media type:" + String.valueOf((Object)fmt.get(FormatKeys.MediaTypeKey)));
    }

    @Deprecated
    public int addVideoTrack(Format format, long timeScale, int width, int height) throws IOException {
        return this.addVideoTrack(format.get(FormatKeys.EncodingKey), format.get(VideoFormatKeys.CompressorNameKey), timeScale, width, height, 24, 30);
    }

    @Deprecated
    public int addVideoTrack(Format format, int width, int height, int depth, int syncInterval) throws IOException {
        return this.addVideoTrack(format.get(FormatKeys.EncodingKey), format.get(VideoFormatKeys.CompressorNameKey), format.get(FormatKeys.FrameRateKey).getDenominator() * format.get(FormatKeys.FrameRateKey).getNumerator(), width, height, depth, syncInterval);
    }

    @Deprecated
    public int addAudioTrack(AudioFormat format) throws IOException {
        String qtAudioFormat;
        boolean signed;
        boolean isCompressed;
        int frameSize;
        int frameDuration;
        ByteOrder byteOrder;
        int numberOfChannels;
        int sampleSizeInBits;
        long timeScale;
        double sampleRate;
        block20: {
            AudioFormat.Encoding enc;
            block22: {
                block21: {
                    block19: {
                        this.ensureStarted();
                        sampleRate = format.getSampleRate();
                        timeScale = (int)Math.floor(sampleRate);
                        sampleSizeInBits = format.getSampleSizeInBits();
                        numberOfChannels = format.getChannels();
                        byteOrder = format.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
                        frameDuration = (int)(format.getSampleRate() / format.getFrameRate());
                        frameSize = format.getFrameSize();
                        isCompressed = format.getProperty("vbr") != null && (Boolean)format.getProperty("vbr") != false;
                        signed = false;
                        enc = format.getEncoding();
                        if (!enc.equals(AudioFormat.Encoding.ALAW)) break block19;
                        qtAudioFormat = "alaw";
                        if (sampleSizeInBits != 8) {
                            throw new IllegalArgumentException("Sample size of 8 for ALAW required:" + sampleSizeInBits);
                        }
                        break block20;
                    }
                    if (!AudioFormat.Encoding.PCM_SIGNED.equals(enc)) break block21;
                    switch (sampleSizeInBits) {
                        case 8: {
                            qtAudioFormat = "raw ";
                            break block20;
                        }
                        case 16: {
                            qtAudioFormat = byteOrder == ByteOrder.BIG_ENDIAN ? "twos" : "sowt";
                            break block20;
                        }
                        case 24: {
                            qtAudioFormat = "in24";
                            break block20;
                        }
                        case 32: {
                            qtAudioFormat = "in32";
                            break block20;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported sample size for PCM_SIGNED:" + sampleSizeInBits);
                        }
                    }
                }
                if (!AudioFormat.Encoding.PCM_UNSIGNED.equals(enc)) break block22;
                switch (sampleSizeInBits) {
                    case 8: {
                        qtAudioFormat = "raw ";
                        break block20;
                    }
                    case 16: {
                        qtAudioFormat = byteOrder == ByteOrder.BIG_ENDIAN ? "twos" : "sowt";
                        break block20;
                    }
                    case 24: {
                        qtAudioFormat = "in24";
                        break block20;
                    }
                    case 32: {
                        qtAudioFormat = "in32";
                        break block20;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported sample size for PCM_UNSIGNED:" + sampleSizeInBits);
                    }
                }
            }
            if (AudioFormat.Encoding.ULAW.equals(enc)) {
                if (sampleSizeInBits != 8) {
                    throw new IllegalArgumentException("Sample size of 8 for ULAW required:" + sampleSizeInBits);
                }
                qtAudioFormat = "ulaw";
            } else if ("MP3".equals(enc == null ? null : enc.toString())) {
                qtAudioFormat = ".mp3";
            } else {
                qtAudioFormat = format.getEncoding().toString();
                if (qtAudioFormat == null || qtAudioFormat.length() != 4) {
                    throw new IllegalArgumentException("Unsupported encoding:" + String.valueOf(format.getEncoding()));
                }
            }
        }
        return this.addAudioTrack(qtAudioFormat, timeScale, sampleRate, numberOfChannels, sampleSizeInBits, isCompressed, frameDuration, frameSize, signed, byteOrder);
    }

    @Override
    public int getTrackCount() {
        return this.tracks.size();
    }

    @Override
    public Rational getDuration(int track) {
        AbstractQuickTimeStream.Track tr = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        return new Rational(tr.mediaDuration, tr.mediaTimeScale);
    }

    private Codec createCodec(Format fmt) {
        return Registry.getInstance().getEncoder(fmt.prepend(FormatKeys.MimeTypeKey, "video/quicktime"));
    }

    private void createCodec(int track) {
        AbstractQuickTimeStream.Track tr = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        Format fmt = tr.format;
        tr.codec = this.createCodec(fmt);
        String enc = fmt.get(FormatKeys.EncodingKey);
        if (tr.codec != null) {
            if (fmt.get(FormatKeys.MediaTypeKey) == FormatKeys.MediaType.VIDEO) {
                Format vf = fmt;
                tr.codec.setInputFormat(fmt.prepend(FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, "image", VideoFormatKeys.DataClassKey, BufferedImage.class));
                if (null == tr.codec.setOutputFormat(fmt.prepend(VideoFormatKeys.QualityKey, Float.valueOf(this.getCompressionQuality(track)), FormatKeys.MimeTypeKey, "video/quicktime", VideoFormatKeys.DataClassKey, byte[].class))) {
                    throw new UnsupportedOperationException("Input format not supported:" + String.valueOf(fmt));
                }
            } else {
                Format vf = fmt;
                tr.codec.setInputFormat(fmt.prepend(FormatKeys.MimeTypeKey, "Java", FormatKeys.EncodingKey, fmt.containsKey(AudioFormatKeys.SignedKey) && fmt.get(AudioFormatKeys.SignedKey) != false ? AudioFormatKeys.ENCODING_PCM_SIGNED : AudioFormatKeys.ENCODING_PCM_UNSIGNED, VideoFormatKeys.DataClassKey, byte[].class));
                if (tr.codec.setOutputFormat(fmt) == null) {
                    throw new UnsupportedOperationException("Codec output format not supported:" + String.valueOf(fmt) + " codec:" + String.valueOf(tr.codec));
                }
                tr.format = tr.codec.getOutputFormat();
            }
        }
    }

    public Codec getCodec(int track) {
        return ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).codec;
    }

    public void setCodec(int track, Codec codec) {
        ((AbstractQuickTimeStream.Track)this.tracks.get((int)track)).codec = codec;
    }

    @Override
    public void write(int track, Buffer buf) throws IOException {
        Rational exactSampleDuration;
        Rational sampleDuration;
        Buffer outBuf;
        this.ensureStarted();
        AbstractQuickTimeStream.Track tr = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        if (tr.outputBuffer == null) {
            tr.outputBuffer = new Buffer();
            tr.outputBuffer.format = tr.format;
        }
        if (tr.format.matchesWithout(buf.format, FormatKeys.FrameRateKey)) {
            outBuf = buf;
        } else {
            outBuf = tr.outputBuffer;
            boolean isSync = tr.syncInterval == 0 ? false : tr.sampleCount % (long)tr.syncInterval == 0L;
            buf.setFlag(BufferFlag.KEYFRAME, isSync);
            if (tr.codec == null) {
                this.createCodec(track);
                if (tr.codec == null) {
                    throw new UnsupportedOperationException("No codec for this format " + String.valueOf(tr.format));
                }
            }
            tr.codec.process(buf, outBuf);
        }
        if (outBuf.isFlag(BufferFlag.DISCARD) || outBuf.sampleCount == 0) {
            return;
        }
        if (tr.inputTime == null) {
            tr.inputTime = buf.timeStamp;
            tr.writeTime = buf.timeStamp;
        }
        if ((sampleDuration = (exactSampleDuration = outBuf.sampleDuration.multiply(outBuf.sampleCount)).floor(tr.mediaTimeScale)).compareTo(new Rational(0L, 1L)) <= 0) {
            sampleDuration = new Rational(1L, tr.mediaTimeScale);
        }
        tr.writeTime = tr.writeTime.add(sampleDuration);
        long sampleDurationInMediaTS = sampleDuration.getNumerator() * (tr.mediaTimeScale / sampleDuration.getDenominator());
        this.writeSamples(track, buf.sampleCount, (byte[])outBuf.data, outBuf.offset, outBuf.length, sampleDurationInMediaTS / (long)buf.sampleCount, outBuf.isFlag(BufferFlag.KEYFRAME));
    }

    public void write(int track, BufferedImage image, long duration) throws IOException {
        if (duration <= 0L) {
            throw new IllegalArgumentException("Duration must be greater 0.");
        }
        AbstractQuickTimeStream.VideoTrack vt = (AbstractQuickTimeStream.VideoTrack)this.tracks.get(track);
        if (vt.mediaType != FormatKeys.MediaType.VIDEO) {
            throw new IllegalArgumentException("Track " + track + " is not a video track");
        }
        if (vt.codec == null) {
            this.createCodec(track);
        }
        if (vt.codec == null) {
            throw new UnsupportedOperationException("No codec for this format: " + String.valueOf(vt.format));
        }
        this.ensureStarted();
        if (vt.width == -1.0) {
            vt.width = image.getWidth();
            vt.height = image.getHeight();
        } else if (vt.width != (double)image.getWidth() || vt.height != (double)image.getHeight()) {
            throw new IllegalArgumentException("Dimensions of frame[" + ((AbstractQuickTimeStream.Track)this.tracks.get(track)).getSampleCount() + "] (width=" + image.getWidth() + ", height=" + image.getHeight() + ") differs from video dimension (width=" + vt.width + ", height=" + vt.height + ") in track " + track + ".");
        }
        if (vt.outputBuffer == null) {
            vt.outputBuffer = new Buffer();
        }
        boolean isSync = vt.syncInterval == 0 ? false : vt.sampleCount % (long)vt.syncInterval == 0L;
        Buffer inputBuffer = new Buffer();
        inputBuffer.setFlag(BufferFlag.KEYFRAME, isSync);
        inputBuffer.data = image;
        vt.codec.process(inputBuffer, vt.outputBuffer);
        if (vt.outputBuffer.isFlag(BufferFlag.DISCARD)) {
            return;
        }
        isSync = vt.outputBuffer.isFlag(BufferFlag.KEYFRAME);
        long offset = this.getRelativeStreamPosition();
        DataAtomOutputStream mdatOut = this.mdatAtom.getOutputStream();
        ((OutputStream)mdatOut).write((byte[])vt.outputBuffer.data, vt.outputBuffer.offset, vt.outputBuffer.length);
        long length = this.getRelativeStreamPosition() - offset;
        vt.addSample(new AbstractQuickTimeStream.Sample(duration, offset, length), 1, isSync);
    }

    @Deprecated
    public void write(int track, byte[] data, int off, int len, long duration, boolean isSync) throws IOException {
        this.writeSamples(track, 1, data, off, len, duration, isSync);
    }

    @Deprecated
    public void write(int track, int sampleCount, byte[] data, int off, int len, long sampleDuration, boolean isSync) throws IOException {
        AbstractQuickTimeStream.Track tr = (AbstractQuickTimeStream.Track)this.tracks.get(track);
        if (tr.codec == null) {
            this.writeSamples(track, sampleCount, data, off, len, sampleDuration, isSync);
        } else {
            if (tr.outputBuffer == null) {
                tr.outputBuffer = new Buffer();
            }
            if (tr.inputBuffer == null) {
                tr.inputBuffer = new Buffer();
            }
            Buffer outb = tr.outputBuffer;
            Buffer inb = tr.inputBuffer;
            inb.data = data;
            inb.offset = off;
            inb.length = len;
            inb.sampleDuration = new Rational(sampleDuration, tr.mediaTimeScale);
            inb.sampleCount = sampleCount;
            inb.setFlag(BufferFlag.KEYFRAME, isSync);
            tr.codec.process(inb, outb);
            if (!outb.isFlag(BufferFlag.DISCARD)) {
                this.writeSample(track, (byte[])outb.data, outb.offset, outb.length, outb.sampleCount, outb.isFlag(BufferFlag.KEYFRAME));
            }
        }
    }

    public boolean isVFRSupported() {
        return true;
    }

    @Override
    public boolean isDataLimitReached() {
        return super.isDataLimitReached();
    }

    @Override
    public boolean isEmpty(int track) {
        return ((AbstractQuickTimeStream.Track)this.tracks.get(track)).isEmpty();
    }
}

