/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.jpeg;

import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.monte.media.image.CMYKImages;
import org.monte.media.io.ByteArrayImageInputStream;
import org.monte.media.io.IOStreams;
import org.monte.media.io.ImageInputStreamAdapter;
import org.monte.media.jfif.JFIFInputStream;
import org.monte.media.jpeg.CMYKJPEGImageReaderSpi;

public class CMYKJPEGImageReader
extends ImageReader {
    private boolean ignoreIccProfile = false;
    private ICC_Profile defaultIccProfile = null;
    private boolean isInvertColors = true;
    private BufferedImage image;
    private boolean didReturnImage;

    public CMYKJPEGImageReader() {
        this(new CMYKJPEGImageReaderSpi());
    }

    public CMYKJPEGImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    @Override
    public int getNumImages(boolean allowSearch) throws IOException {
        return 1;
    }

    @Override
    public int getWidth(int imageIndex) throws IOException {
        this.readHeader();
        return this.image.getWidth();
    }

    @Override
    public int getHeight(int imageIndex) throws IOException {
        this.readHeader();
        return this.image.getHeight();
    }

    @Override
    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        this.readHeader();
        LinkedList<ImageTypeSpecifier> l = new LinkedList<ImageTypeSpecifier>();
        l.add(new ImageTypeSpecifier(CMYKImages.RGB, CMYKImages.RGB.createCompatibleSampleModel(this.image.getWidth(), this.image.getHeight())));
        return l.iterator();
    }

    @Override
    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    @Override
    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        return null;
    }

    @Override
    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        if (imageIndex > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.readHeader();
        this.didReturnImage = true;
        return this.image;
    }

    private void readHeader() throws IOException {
        if (this.image == null) {
            ImageInputStream iis = null;
            Object in = this.getInput();
            if (in instanceof byte[]) {
                iis = new ByteArrayImageInputStream((byte[])in);
            } else if (in instanceof ImageInputStream) {
                iis = (ImageInputStream)in;
            } else if (in instanceof InputStream) {
                iis = new MemoryCacheImageInputStream((InputStream)in);
            } else {
                throw new IOException("Can't handle input of type " + String.valueOf(in));
            }
            this.didReturnImage = false;
            this.image = CMYKJPEGImageReader.read(iis, this.isInvertColors, this.ignoreIccProfile, this.defaultIccProfile);
        }
    }

    public boolean isInvertColors() {
        return this.isInvertColors;
    }

    public void setInvertColors(boolean newValue) {
        this.isInvertColors = newValue;
    }

    public boolean isIgnoreIccProfile() {
        return this.ignoreIccProfile;
    }

    public void setIgnoreIccProfile(boolean newValue) {
        this.ignoreIccProfile = newValue;
    }

    public ICC_Profile getDefaultIccProfile() {
        return this.defaultIccProfile;
    }

    public void setDefaultIccProfile(ICC_Profile newValue) {
        this.defaultIccProfile = newValue;
    }

    public static BufferedImage read(ImageInputStream in, boolean inverseYCCKColors, boolean ignoreProfile, ICC_Profile defaultProfile) throws IOException {
        in.seek(0L);
        int samplePrecision = 0;
        int numberOfLines = 0;
        int numberOfSamplesPerLine = 0;
        int numberOfComponentsInFrame = 0;
        int app14AdobeColorTransform = 0;
        ByteArrayOutputStream app2ICCProfile = new ByteArrayOutputStream();
        JFIFInputStream fifi = new JFIFInputStream(new ImageInputStreamAdapter(in));
        JFIFInputStream.Segment seg = fifi.getNextSegment();
        while (seg != null) {
            DataInputStream dis;
            if (65472 <= seg.marker && seg.marker <= 65475 || 65477 <= seg.marker && seg.marker <= 65479 || 65481 <= seg.marker && seg.marker <= 65483 || 65485 <= seg.marker && seg.marker <= 65487) {
                dis = new DataInputStream(fifi);
                samplePrecision = dis.readUnsignedByte();
                numberOfLines = dis.readUnsignedShort();
                numberOfSamplesPerLine = dis.readUnsignedShort();
                numberOfComponentsInFrame = dis.readUnsignedByte();
                break;
            }
            if (seg.marker == 65506) {
                if (seg.length >= 26 && (dis = new DataInputStream(fifi)).readLong() == 5279137264856878918L && dis.readInt() == 1229735168) {
                    dis.skipBytes(2);
                    IOStreams.copy((InputStream)dis, app2ICCProfile);
                }
            } else if (seg.marker == 65518 && seg.length == 12 && (long)(dis = new DataInputStream(fifi)).readInt() == 1097101154L && dis.readUnsignedShort() == 25856) {
                int version = dis.readUnsignedByte();
                int app14Flags0 = dis.readUnsignedShort();
                int app14Flags1 = dis.readUnsignedShort();
                app14AdobeColorTransform = dis.readUnsignedByte();
            }
            seg = fifi.getNextSegment();
        }
        ICC_Profile profile = defaultProfile;
        if (!ignoreProfile && app2ICCProfile.size() > 0) {
            try {
                profile = ICC_Profile.getInstance(new ByteArrayInputStream(app2ICCProfile.toByteArray()));
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        BufferedImage img = null;
        if (numberOfComponentsInFrame != 4) {
            in.seek(0L);
            img = CMYKJPEGImageReader.readImageFromYCC(new ImageInputStreamAdapter(in), null);
        } else if (numberOfComponentsInFrame == 4) {
            switch (app14AdobeColorTransform) {
                default: {
                    in.seek(0L);
                    if (inverseYCCKColors) {
                        img = CMYKJPEGImageReader.readImageFromInvertedCMYK(new ImageInputStreamAdapter(in), profile);
                        break;
                    }
                    img = CMYKJPEGImageReader.readImageFromCMYK(new ImageInputStreamAdapter(in), profile);
                    break;
                }
                case 1: {
                    throw new IOException("YCbCr not supported");
                }
                case 2: {
                    in.seek(0L);
                    img = inverseYCCKColors ? CMYKJPEGImageReader.readImageFromInvertedYCCK(new ImageInputStreamAdapter(in), profile) : CMYKJPEGImageReader.readImageFromYCCK(new ImageInputStreamAdapter(in), profile);
                }
            }
        }
        return img;
    }

    public static ImageReader createNativeJPEGReader() {
        for (ImageReader r : () -> ImageIO.getImageReadersByFormatName("jpeg")) {
            if (!"com.sun.imageio.plugins.jpeg.JPEGImageReader".equals(r.getClass().getName())) continue;
            return r;
        }
        throw new InternalError("could not find native JPEG Reader");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImageFromCMYK(InputStream in, ICC_Profile cmykProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage image;
            inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
            reader.setInput(inputStream);
            Raster raster = reader.readRaster(0, null);
            BufferedImage bufferedImage = image = CMYKImages.createImageFromCMYK(raster, cmykProfile);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImageFromInvertedCMYK(InputStream in, ICC_Profile rgbaProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage image;
            inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
            reader.setInput(inputStream);
            Raster raster = reader.readRaster(0, null);
            BufferedImage bufferedImage = image = CMYKImages.createImageFromInvertedCMYK(raster, rgbaProfile);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImageFromRGB(InputStream in, ICC_Profile rgbaProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage image;
            inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
            reader.setInput(inputStream);
            Raster raster = reader.readRaster(0, null);
            BufferedImage bufferedImage = image = CMYKImages.createImageFromRGB(raster, rgbaProfile);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImageFromYCC(InputStream in, ICC_Profile yccProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage image;
            inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
            reader.setInput(inputStream);
            Raster raster = reader.readRaster(0, null);
            BufferedImage bufferedImage = image = CMYKImages.createImageFromYCC(raster, yccProfile);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImageFromYCCK(InputStream in, ICC_Profile cmykProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage image;
            inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
            reader.setInput(inputStream);
            Raster raster = reader.readRaster(0, null);
            BufferedImage bufferedImage = image = CMYKImages.createImageFromYCCK(raster, cmykProfile);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImageFromInvertedYCCK(InputStream in, ICC_Profile cmykProfile) throws IOException {
        ImageInputStream inputStream = null;
        ImageReader reader = CMYKJPEGImageReader.createNativeJPEGReader();
        try {
            BufferedImage image;
            inputStream = in instanceof ImageInputStream ? (ImageInputStream)((Object)in) : ImageIO.createImageInputStream(in);
            reader.setInput(inputStream);
            Raster raster = reader.readRaster(0, null);
            BufferedImage bufferedImage = image = CMYKImages.createImageFromInvertedYCCK(raster, cmykProfile);
            return bufferedImage;
        }
        finally {
            reader.dispose();
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.image != null && !this.didReturnImage) {
                this.image.flush();
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            this.image = null;
        }
    }
}

