/*
 * Decompiled with CFR 0.152.
 */
package org.monte.media.imgseq;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.monte.media.av.Buffer;
import org.monte.media.av.BufferFlag;
import org.monte.media.av.Multiplexer;
import org.monte.media.io.IOStreams;

public class FileMultiplexer
implements Multiplexer {
    private File dir;
    private String baseName;
    private String extension;
    private long position = 0L;
    private int minDigits = 4;

    public FileMultiplexer(File dir, String baseName, String extension) {
        this.dir = dir;
        this.baseName = baseName;
        this.extension = extension;
    }

    @Override
    public void write(int track, Buffer buf) throws IOException {
        if (buf.isFlag(BufferFlag.DISCARD)) {
            return;
        }
        File file = new File(this.dir, this.baseName + this.numToString(this.position + 1L) + this.extension);
        if (buf.data instanceof byte[]) {
            try (FileOutputStream out = new FileOutputStream(file);){
                out.write((byte[])buf.data, buf.offset, buf.length);
            }
        } else if (buf.data instanceof File) {
            IOStreams.copy((File)buf.data, file);
        } else {
            throw new IllegalArgumentException("Can't process buffer data:" + String.valueOf(buf.data));
        }
        ++this.position;
    }

    private String numToString(long num) {
        StringBuilder b = new StringBuilder();
        b.append(Long.toString(num));
        while (b.length() < this.minDigits) {
            b.insert(0, '0');
        }
        return b.toString();
    }

    @Override
    public void close() throws IOException {
    }
}

