/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.fastdoubleparser;

import ch.randelshofer.fastdoubleparser.AbstractFloatValueParser;
import ch.randelshofer.fastdoubleparser.NumberFormatSymbols;
import ch.randelshofer.fastdoubleparser.SlowDoubleConversionPath;
import ch.randelshofer.fastdoubleparser.chr.CharDigitSet;
import ch.randelshofer.fastdoubleparser.chr.CharSet;
import ch.randelshofer.fastdoubleparser.chr.CharTrie;

abstract class AbstractConfigurableFloatingPointBitsFromCharArray
extends AbstractFloatValueParser {
    private final CharDigitSet digitSet;
    private final CharSet minusSignChar;
    private final CharSet plusSignChar;
    private final CharSet decimalSeparator;
    private final CharSet groupingSeparator;
    private final CharTrie nanTrie;
    private final CharTrie infinityTrie;
    private final CharTrie exponentSeparatorTrie;

    public AbstractConfigurableFloatingPointBitsFromCharArray(NumberFormatSymbols symbols, boolean ignoreCase) {
        this.decimalSeparator = CharSet.copyOf(symbols.decimalSeparator(), ignoreCase);
        this.groupingSeparator = CharSet.copyOf(symbols.groupingSeparator(), ignoreCase);
        this.digitSet = CharDigitSet.copyOf(symbols.digits());
        this.minusSignChar = CharSet.copyOf(symbols.minusSign(), ignoreCase);
        this.exponentSeparatorTrie = CharTrie.copyOf(symbols.exponentSeparator(), ignoreCase);
        this.plusSignChar = CharSet.copyOf(symbols.plusSign(), ignoreCase);
        this.nanTrie = CharTrie.copyOf(symbols.nan(), ignoreCase);
        this.infinityTrie = CharTrie.copyOf(symbols.infinity(), ignoreCase);
    }

    abstract long nan();

    abstract long negativeInfinity();

    private boolean isDecimalSeparator(char ch) {
        return this.decimalSeparator.containsKey(ch);
    }

    private boolean isGroupingSeparator(char ch) {
        return this.groupingSeparator.containsKey(ch);
    }

    public final long parseFloatingPointLiteral(char[] str, int offset, int length) {
        int exponentOfTruncatedSignificand;
        boolean isSignificandTruncated;
        int exponent;
        int digitCount;
        int endIndex = AbstractConfigurableFloatingPointBitsFromCharArray.checkBounds(str.length, offset, length);
        int index = AbstractConfigurableFloatingPointBitsFromCharArray.skipFormatCharacters(str, offset, endIndex);
        if (index == endIndex) {
            return 9221120237041090561L;
        }
        char ch = str[index];
        boolean isNegative = this.isMinusSign(ch);
        if ((isNegative || this.isPlusSign(ch)) && ++index == endIndex) {
            return 9221120237041090561L;
        }
        long significand = 0L;
        int significandStartIndex = index;
        int decimalSeparatorIndex = -1;
        int integerDigitCount = -1;
        int groupingCount = 0;
        boolean illegal = false;
        while (index < endIndex) {
            ch = str[index];
            int digit = this.digitSet.toDigit(ch);
            if (digit < 10) {
                significand = 10L * significand + (long)digit;
            } else if (this.isDecimalSeparator(ch)) {
                illegal |= integerDigitCount >= 0;
                decimalSeparatorIndex = index;
                integerDigitCount = index - significandStartIndex - groupingCount;
            } else {
                if (!this.isGroupingSeparator(ch)) break;
                illegal |= decimalSeparatorIndex != -1;
                ++groupingCount;
            }
            ++index;
        }
        int significandEndIndex = index;
        if (integerDigitCount < 0) {
            integerDigitCount = digitCount = significandEndIndex - significandStartIndex - groupingCount;
            decimalSeparatorIndex = significandEndIndex;
            exponent = 0;
        } else {
            digitCount = significandEndIndex - significandStartIndex - 1 - groupingCount;
            exponent = integerDigitCount - digitCount;
        }
        illegal |= digitCount == 0 && significandEndIndex > significandStartIndex;
        int expNumber = 0;
        int count = this.exponentSeparatorTrie.match(str, index, endIndex);
        if (count > 0) {
            int digit;
            index += count;
            ch = AbstractConfigurableFloatingPointBitsFromCharArray.charAt(str, index = AbstractConfigurableFloatingPointBitsFromCharArray.skipFormatCharacters(str, index, endIndex), endIndex);
            boolean isExponentNegative = this.isMinusSign(ch);
            if (isExponentNegative || this.isPlusSign(ch)) {
                ch = AbstractConfigurableFloatingPointBitsFromCharArray.charAt(str, ++index, endIndex);
            }
            illegal |= (digit = this.digitSet.toDigit(ch)) >= 10;
            do {
                if (expNumber >= 1024) continue;
                expNumber = 10 * expNumber + digit;
            } while ((digit = this.digitSet.toDigit(ch = AbstractConfigurableFloatingPointBitsFromCharArray.charAt(str, ++index, endIndex))) < 10);
            if (isExponentNegative) {
                expNumber = -expNumber;
            }
            exponent += expNumber;
        }
        if (!illegal && digitCount == 0) {
            return this.parseNaNOrInfinity(str, index, endIndex, isNegative);
        }
        if (illegal || index < endIndex) {
            return 9221120237041090561L;
        }
        if (digitCount > 19) {
            int truncatedDigitCount = 0;
            significand = 0L;
            for (index = significandStartIndex; index < significandEndIndex; ++index) {
                ch = str[index];
                int digit = this.digitSet.toDigit(ch);
                if (digit >= 10) continue;
                if (Long.compareUnsigned(significand, 1000000000000000000L) >= 0) break;
                significand = 10L * significand + (long)digit;
                ++truncatedDigitCount;
            }
            isSignificandTruncated = index < significandEndIndex;
            exponentOfTruncatedSignificand = integerDigitCount - truncatedDigitCount + expNumber;
        } else {
            isSignificandTruncated = false;
            exponentOfTruncatedSignificand = 0;
        }
        return this.valueOfFloatLiteral(str, significandStartIndex, decimalSeparatorIndex, decimalSeparatorIndex + 1, significandEndIndex, isNegative, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand, expNumber, offset, endIndex);
    }

    private boolean isMinusSign(char c) {
        return this.minusSignChar.containsKey(c);
    }

    private boolean isPlusSign(char c) {
        return this.plusSignChar.containsKey(c);
    }

    private static int skipFormatCharacters(char[] str, int index, int endIndex) {
        while (index < endIndex && Character.getType(str[index]) == 16) {
            ++index;
        }
        return index;
    }

    private long parseNaNOrInfinity(char[] str, int index, int endIndex, boolean isNegative) {
        int nanMatch = this.nanTrie.match(str, index, endIndex);
        if (nanMatch > 0 && index + nanMatch == endIndex) {
            return this.nan();
        }
        int infinityMatch = this.infinityTrie.match(str, index, endIndex);
        if (infinityMatch > 0 && index + infinityMatch == endIndex) {
            return isNegative ? this.negativeInfinity() : this.positiveInfinity();
        }
        return 9221120237041090561L;
    }

    abstract long positiveInfinity();

    abstract long valueOfFloatLiteral(char[] var1, int var2, int var3, int var4, int var5, boolean var6, long var7, int var9, boolean var10, int var11, int var12, int var13, int var14);

    protected double slowPathToDouble(char[] str, int integerStartIndex, int integerEndIndex, int fractionStartIndex, int fractionEndIndex, boolean isSignificandNegative, int exponentValue) {
        return SlowDoubleConversionPath.toDouble(str, this.digitSet, integerStartIndex, integerEndIndex, fractionStartIndex, fractionEndIndex, isSignificandNegative, (long)exponentValue);
    }
}

