/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class JsonHandler {
    private ObjectMapper mapper;

    public JsonHandler() {
        this.mapper = new ObjectMapper();
    }

    public JsonHandler(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public void setMapper(ObjectMapper mapper) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        this.mapper = mapper;
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    public String writeValueAsString(Object obj) {
        return this.writeValueAsString(obj, false);
    }

    public String writeValueAsString(Object obj, boolean indent) {
        try {
            if (indent) {
                return this.mapper.writer().withDefaultPrettyPrinter().writeValueAsString(obj);
            }
            return this.mapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            LogFactory.getLog(JsonHandler.class).info((Object)"serialize object to json", (Throwable)e);
            return null;
        }
    }

    public <T> T readValue(String json, TypeReference<T> typeReference) {
        try {
            return (T)this.mapper.readValue(json, typeReference);
        }
        catch (Exception e) {
            LogFactory.getLog(JsonHandler.class).info((Object)"deserialize json to object", (Throwable)e);
            return null;
        }
    }

    public <T> T readValue(String json, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(json, clazz);
        }
        catch (Exception e) {
            LogFactory.getLog(JsonHandler.class).info((Object)"deserialize json to object", (Throwable)e);
            return null;
        }
    }

    public Object readValue(InputStream is, Class<Object> clazz) {
        try {
            return this.mapper.readValue(is, clazz);
        }
        catch (Exception e) {
            LogFactory.getLog(JsonHandler.class).info((Object)"deserialize json to object", (Throwable)e);
            return null;
        }
    }

    public <T> T convertValue(Object object, Class<T> clazz) {
        return (T)this.mapper.convertValue(object, clazz);
    }

    public <T> T convertValue(Object object, JavaType toValueTypeRef) {
        return (T)this.mapper.convertValue(object, toValueTypeRef);
    }
}

