/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean;

import ch.ralscha.extdirectspring.bean.ExtDirectResponse;
import ch.ralscha.extdirectspring.controller.Configuration;
import ch.ralscha.extdirectspring.controller.RouterController;
import ch.ralscha.extdirectspring.util.ExtDirectSpringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.MessageSource;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;

public class ExtDirectResponseBuilder {
    private final ExtDirectResponse extDirectResponse;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final Map<String, Object> result;
    private Class<?> jsonView;

    public ExtDirectResponseBuilder(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
        this.extDirectResponse = new ExtDirectResponse(request);
        this.result = new HashMap<String, Object>();
        this.successful();
        this.extDirectResponse.setResult(this.result);
    }

    public static ExtDirectResponseBuilder create(HttpServletRequest request, HttpServletResponse response) {
        return new ExtDirectResponseBuilder(request, response);
    }

    public ExtDirectResponseBuilder setException(Exception exception) {
        Configuration configuration;
        this.unsuccessful();
        WebApplicationContext ctx = RequestContextUtils.getWebApplicationContext((ServletRequest)this.request);
        try {
            configuration = (Configuration)ctx.getBean(Configuration.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            configuration = new Configuration();
        }
        this.extDirectResponse.setType("exception");
        this.extDirectResponse.setMessage(configuration.getMessage(exception));
        if (configuration.isSendStacktrace()) {
            this.extDirectResponse.setWhere(ExtDirectSpringUtil.getStackTrace(exception));
        } else {
            this.extDirectResponse.setWhere(null);
        }
        return this;
    }

    public ExtDirectResponseBuilder addErrors(BindingResult bindingResult) {
        this.addErrors(null, null, bindingResult);
        return this;
    }

    public ExtDirectResponseBuilder addErrors(Locale locale, MessageSource messageSource, BindingResult bindingResult) {
        if (bindingResult != null && bindingResult.hasFieldErrors()) {
            HashMap<String, ArrayList<String>> errorMap = new HashMap<String, ArrayList<String>>();
            for (FieldError fieldError : bindingResult.getFieldErrors()) {
                ArrayList<String> fieldErrors;
                String message = fieldError.getDefaultMessage();
                if (messageSource != null) {
                    Locale loc = locale != null ? locale : Locale.getDefault();
                    message = messageSource.getMessage(fieldError.getCode(), fieldError.getArguments(), loc);
                }
                if ((fieldErrors = (ArrayList<String>)errorMap.get(fieldError.getField())) == null) {
                    fieldErrors = new ArrayList<String>();
                    errorMap.put(fieldError.getField(), fieldErrors);
                }
                fieldErrors.add(message);
            }
            if (errorMap.isEmpty()) {
                this.addResultProperty("success", Boolean.TRUE);
            } else {
                this.addResultProperty("errors", errorMap);
                this.addResultProperty("success", Boolean.FALSE);
            }
        }
        return this;
    }

    public ExtDirectResponseBuilder addResultProperty(String key, Object value) {
        this.result.put(key, value);
        return this;
    }

    public ExtDirectResponseBuilder successful() {
        this.result.put("success", Boolean.TRUE);
        return this;
    }

    public ExtDirectResponseBuilder unsuccessful() {
        this.result.put("success", Boolean.FALSE);
        return this;
    }

    public ExtDirectResponseBuilder setSuccess(boolean flag) {
        this.result.put("success", flag);
        return this;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public void buildAndWrite() {
        try {
            RouterController routerController = (RouterController)RequestContextUtils.getWebApplicationContext((ServletRequest)this.request).getBean(RouterController.class);
            routerController.writeJsonResponse(this.request, this.response, this.extDirectResponse, this.jsonView);
        }
        catch (IOException e) {
            LogFactory.getLog(this.getClass()).error((Object)"buildAndWrite", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

