/*
 * Decompiled with CFR 0.152.
 */
package ch.ralscha.extdirectspring.bean;

import ch.ralscha.extdirectspring.bean.BaseResponse;
import ch.ralscha.extdirectspring.bean.ExtDirectRequest;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import javax.servlet.http.HttpServletRequest;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExtDirectResponse
extends BaseResponse {
    private int tid;
    private String action;
    private String method;
    private Object result;
    private boolean streamResponse;
    @JsonIgnore
    private Class<?> jsonView;

    public ExtDirectResponse() {
    }

    public ExtDirectResponse(ExtDirectRequest directRequest) {
        this.action = directRequest.getAction();
        this.method = directRequest.getMethod();
        this.tid = directRequest.getTid();
        this.setType(directRequest.getType());
    }

    public ExtDirectResponse(HttpServletRequest request) {
        this.action = request.getParameter("extAction");
        this.method = request.getParameter("extMethod");
        this.tid = Integer.parseInt(request.getParameter("extTID"));
        this.setType(request.getParameter("extType"));
    }

    public String getAction() {
        return this.action;
    }

    public String getMethod() {
        return this.method;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public int getTid() {
        return this.tid;
    }

    @JsonIgnore
    public boolean isStreamResponse() {
        return this.streamResponse;
    }

    public void setStreamResponse(boolean streamResponse) {
        this.streamResponse = streamResponse;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public String toString() {
        return "ExtDirectResponse [tid=" + this.tid + ", action=" + this.action + ", method=" + this.method + ", result=" + this.result + ", streamResponse=" + this.streamResponse + ", jsonView=" + this.jsonView + "]";
    }
}

