/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.CharSequenceToRegexMapper;
import java.text.DateFormatSymbols;
import java.util.Locale;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class CharSequenceToRegexMapperTest {
    static Locale KO_LOCALE = new Locale("ko", "KR");
    Locale oldLocale = Locale.getDefault();

    @AfterEach
    public void tearDown() {
        Locale.setDefault(this.oldLocale);
    }

    @Test
    public void findMinMaxLengthsInSymbolsWithTrivialInputs() {
        String[] symbols = new String[]{"a", "bb"};
        int[] results = CharSequenceToRegexMapper.findMinMaxLengthsInSymbols((String[])symbols);
        Assertions.assertEquals((int)1, (int)results[0]);
        Assertions.assertEquals((int)2, (int)results[1]);
    }

    @Test
    public void emptyStringValuesShouldBeIgnoredByFindMinMaxLengthsInSymbols() {
        String[] symbols = new String[]{"aaa", ""};
        int[] results = CharSequenceToRegexMapper.findMinMaxLengthsInSymbols((String[])symbols);
        Assertions.assertEquals((int)3, (int)results[0]);
        Assertions.assertEquals((int)3, (int)results[1]);
    }

    @Test
    @Disabled
    public void noneOfTheSymbolsAreOfZeroLengthForKorean() {
        Locale.setDefault(KO_LOCALE);
        this.noneOfTheSymbolsAreOfZeroLength();
    }

    @Test
    @Disabled
    public void noneOfTheSymbolsAreOfZeroLengthForSwiss() {
        Locale.setDefault(new Locale("fr", "CH"));
        this.noneOfTheSymbolsAreOfZeroLength();
    }

    private void noneOfTheSymbolsAreOfZeroLength() {
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance();
        this.checkEmptyString(dateFormatSymbols.getShortWeekdays(), "ShortWeekdays");
        this.checkEmptyString(dateFormatSymbols.getWeekdays(), "Weekdays");
        this.checkEmptyString(dateFormatSymbols.getAmPmStrings(), "AmPmStrings");
    }

    private void checkEmptyString(String[] symbolArray, String category) {
        for (String s : symbolArray) {
            System.out.println(category + " [" + s + "]");
            Assertions.assertTrue((s.length() > 0 ? 1 : 0) != 0, (String)(category + " contains empty strings"));
        }
    }
}

