/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import java.util.Iterator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StatusBaseTest {
    @Test
    public void testAddStatus() {
        InfoStatus status = new InfoStatus("testing", (Object)this);
        status.add((Status)new ErrorStatus("error", (Object)this));
        Iterator it = status.iterator();
        Assertions.assertTrue((boolean)it.hasNext(), (String)"No status was added");
        Assertions.assertTrue((boolean)status.hasChildren(), (String)"hasChilden method reported wrong result");
        status = new InfoStatus("testing", (Object)this);
        try {
            status.add(null);
            Assertions.fail((String)"method should have thrown an Exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testRemoveStatus() {
        InfoStatus status = new InfoStatus("testing", (Object)this);
        ErrorStatus error = new ErrorStatus("error", (Object)this);
        status.add((Status)error);
        boolean result = status.remove((Status)error);
        Iterator it = status.iterator();
        Assertions.assertTrue((boolean)result, (String)"Remove failed");
        Assertions.assertFalse((boolean)it.hasNext(), (String)"No status was removed");
        Assertions.assertFalse((boolean)status.hasChildren(), (String)"hasChilden method reported wrong result");
        status = new InfoStatus("testing", (Object)this);
        error = new ErrorStatus("error", (Object)this);
        status.add((Status)error);
        result = status.remove(null);
        Assertions.assertFalse((boolean)result, (String)"Remove result was not false");
    }

    public void testEffectiveLevel() {
        ErrorStatus status = new ErrorStatus("error", (Object)this);
        WarnStatus warn = new WarnStatus("warning", (Object)this);
        status.add((Status)warn);
        Assertions.assertEquals((int)status.getEffectiveLevel(), (int)2, (String)"effective level misevaluated");
        status = new InfoStatus("info", (Object)this);
        warn = new WarnStatus("warning", (Object)this);
        status.add((Status)warn);
        Assertions.assertEquals((int)status.getEffectiveLevel(), (int)1, (String)"effective level misevaluated");
        status = new InfoStatus("info", (Object)this);
        warn = new WarnStatus("warning", (Object)this);
        ErrorStatus error = new ErrorStatus("error", (Object)this);
        status.add((Status)warn);
        warn.add((Status)error);
        Assertions.assertEquals((int)status.getEffectiveLevel(), (int)2, (String)"effective level misevaluated");
    }
}

