/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.recovery;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.io.File;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class ResilientOutputStreamTest {
    int diff = RandomUtil.getPositiveInt();
    Context context = new ContextBase();

    @BeforeAll
    public static void setUp() {
        File file = new File("target/test-output/");
        file.mkdirs();
    }

    @Test
    public void verifyRecuperationAfterFailure() throws Exception {
        File file = new File("target/test-output/resilient" + this.diff + ".log");
        ResilientFileOutputStream rfos = new ResilientFileOutputStream(file, true, 8192L);
        rfos.setContext(this.context);
        ResilientFileOutputStream spy = (ResilientFileOutputStream)Mockito.spy((Object)rfos);
        spy.write("a".getBytes());
        spy.flush();
        spy.getChannel().close();
        spy.write("b".getBytes());
        spy.flush();
        Thread.sleep(30L);
        spy.write("c".getBytes());
        spy.flush();
        ((ResilientFileOutputStream)Mockito.verify((Object)spy)).openNewOutputStream();
    }
}

