/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.net.ssl;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.net.ssl.SSLConfigurable;
import ch.qos.logback.core.net.ssl.SSLParametersConfiguration;
import ch.qos.logback.core.net.ssl.mock.MockSSLConfigurable;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SSLParametersConfigurationTest {
    private MockSSLConfigurable configurable = new MockSSLConfigurable();
    private SSLParametersConfiguration configuration = new SSLParametersConfiguration();

    @BeforeEach
    public void setUp() throws Exception {
        this.configuration.setContext((Context)new ContextBase());
    }

    @Test
    public void testSetIncludedProtocols() throws Exception {
        this.configurable.setSupportedProtocols(new String[]{"A", "B", "C", "D"});
        this.configuration.setIncludedProtocols("A,B ,C, D");
        this.configuration.configure((SSLConfigurable)this.configurable);
        Assertions.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "C", "D"}, this.configurable.getEnabledProtocols()));
    }

    @Test
    public void testSetExcludedProtocols() throws Exception {
        this.configurable.setSupportedProtocols(new String[]{"A", "B"});
        this.configuration.setExcludedProtocols("A");
        this.configuration.configure((SSLConfigurable)this.configurable);
        Assertions.assertTrue((boolean)Arrays.equals(new String[]{"B"}, this.configurable.getEnabledProtocols()));
    }

    @Test
    public void testSetIncludedAndExcludedProtocols() throws Exception {
        this.configurable.setSupportedProtocols(new String[]{"A", "B", "C"});
        this.configuration.setIncludedProtocols("A, B");
        this.configuration.setExcludedProtocols("B");
        this.configuration.configure((SSLConfigurable)this.configurable);
        Assertions.assertTrue((boolean)Arrays.equals(new String[]{"A"}, this.configurable.getEnabledProtocols()));
    }

    @Test
    public void testSetIncludedCipherSuites() throws Exception {
        this.configurable.setSupportedCipherSuites(new String[]{"A", "B", "C", "D"});
        this.configuration.setIncludedCipherSuites("A,B ,C, D");
        this.configuration.configure((SSLConfigurable)this.configurable);
        Assertions.assertTrue((boolean)Arrays.equals(new String[]{"A", "B", "C", "D"}, this.configurable.getEnabledCipherSuites()));
    }

    @Test
    public void testSetExcludedCipherSuites() throws Exception {
        this.configurable.setSupportedCipherSuites(new String[]{"A", "B"});
        this.configuration.setExcludedCipherSuites("A");
        this.configuration.configure((SSLConfigurable)this.configurable);
        Assertions.assertTrue((boolean)Arrays.equals(new String[]{"B"}, this.configurable.getEnabledCipherSuites()));
    }

    @Test
    public void testSetExcludedAndIncludedCipherSuites() throws Exception {
        this.configurable.setSupportedCipherSuites(new String[]{"A", "B", "C"});
        this.configuration.setIncludedCipherSuites("A, B");
        this.configuration.setExcludedCipherSuites("B");
        this.configuration.configure((SSLConfigurable)this.configurable);
        Assertions.assertTrue((boolean)Arrays.equals(new String[]{"A"}, this.configurable.getEnabledCipherSuites()));
    }

    @Test
    public void testSetNeedClientAuth() throws Exception {
        this.configuration.setNeedClientAuth(Boolean.valueOf(true));
        this.configuration.configure((SSLConfigurable)this.configurable);
        Assertions.assertTrue((boolean)this.configurable.isNeedClientAuth());
    }

    @Test
    public void testSetWantClientAuth() throws Exception {
        this.configuration.setWantClientAuth(Boolean.valueOf(true));
        this.configuration.configure((SSLConfigurable)this.configurable);
        Assertions.assertTrue((boolean)this.configurable.isWantClientAuth());
    }

    @Test
    public void testPassDefaultProtocols() throws Exception {
        Object[] protocols = new String[]{"A"};
        this.configurable.setDefaultProtocols((String[])protocols);
        this.configuration.configure((SSLConfigurable)this.configurable);
        Assertions.assertTrue((boolean)Arrays.equals(protocols, this.configurable.getEnabledProtocols()));
    }

    @Test
    public void testPassDefaultCipherSuites() throws Exception {
        Object[] cipherSuites = new String[]{"A"};
        this.configurable.setDefaultCipherSuites((String[])cipherSuites);
        this.configuration.configure((SSLConfigurable)this.configurable);
        Assertions.assertTrue((boolean)Arrays.equals(cipherSuites, this.configurable.getEnabledCipherSuites()));
    }

    @Test
    public void testPassDefaultNeedClientAuth() throws Exception {
        this.configurable.setNeedClientAuth(true);
        this.configuration.configure((SSLConfigurable)this.configurable);
        Assertions.assertTrue((boolean)this.configurable.isNeedClientAuth());
    }

    @Test
    public void testPassDefaultWantClientAuth() throws Exception {
        this.configurable.setWantClientAuth(true);
        this.configuration.configure((SSLConfigurable)this.configurable);
        Assertions.assertTrue((boolean)this.configurable.isWantClientAuth());
    }
}

