/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.ElementSelector;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ElementSelectorTest {
    @Test
    public void test1() {
        ElementSelector p = new ElementSelector("a");
        Assertions.assertEquals((int)1, (int)p.size());
        Assertions.assertEquals((Object)"a", (Object)p.peekLast());
        Assertions.assertEquals((Object)"a", (Object)p.get(0));
    }

    @Test
    public void testSuffix() {
        ElementSelector p = new ElementSelector("a/");
        Assertions.assertEquals((int)1, (int)p.size());
        Assertions.assertEquals((Object)"a", (Object)p.peekLast());
        Assertions.assertEquals((Object)"a", (Object)p.get(0));
    }

    @Test
    public void test2() {
        ElementSelector p = new ElementSelector("a/b");
        Assertions.assertEquals((int)2, (int)p.size());
        Assertions.assertEquals((Object)"b", (Object)p.peekLast());
        Assertions.assertEquals((Object)"a", (Object)p.get(0));
        Assertions.assertEquals((Object)"b", (Object)p.get(1));
    }

    @Test
    public void test3() {
        ElementSelector p = new ElementSelector("a123/b1234/cvvsdf");
        Assertions.assertEquals((int)3, (int)p.size());
        Assertions.assertEquals((Object)"a123", (Object)p.get(0));
        Assertions.assertEquals((Object)"b1234", (Object)p.get(1));
        Assertions.assertEquals((Object)"cvvsdf", (Object)p.get(2));
    }

    @Test
    public void test4() {
        ElementSelector p = new ElementSelector("/a123/b1234/cvvsdf");
        Assertions.assertEquals((int)3, (int)p.size());
        Assertions.assertEquals((Object)"a123", (Object)p.get(0));
        Assertions.assertEquals((Object)"b1234", (Object)p.get(1));
        Assertions.assertEquals((Object)"cvvsdf", (Object)p.get(2));
    }

    @Test
    public void test5() {
        ElementSelector p = new ElementSelector("//a");
        Assertions.assertEquals((int)1, (int)p.size());
        Assertions.assertEquals((Object)"a", (Object)p.get(0));
    }

    @Test
    public void test6() {
        ElementSelector p = new ElementSelector("//a//b");
        Assertions.assertEquals((int)2, (int)p.size());
        Assertions.assertEquals((Object)"a", (Object)p.get(0));
        Assertions.assertEquals((Object)"b", (Object)p.get(1));
    }

    @Test
    public void testTailMatch() {
        ElementPath p = new ElementPath("/a/b");
        ElementSelector ruleElementSelector = new ElementSelector("*");
        Assertions.assertEquals((int)0, (int)ruleElementSelector.getTailMatchLength(p));
        p = new ElementPath("/a");
        ruleElementSelector = new ElementSelector("*/a");
        Assertions.assertEquals((int)1, (int)ruleElementSelector.getTailMatchLength(p));
        p = new ElementPath("/A");
        ruleElementSelector = new ElementSelector("*/a");
        Assertions.assertEquals((int)1, (int)ruleElementSelector.getTailMatchLength(p));
        p = new ElementPath("/a");
        ruleElementSelector = new ElementSelector("*/A");
        Assertions.assertEquals((int)1, (int)ruleElementSelector.getTailMatchLength(p));
        p = new ElementPath("/a/b");
        ruleElementSelector = new ElementSelector("*/b");
        Assertions.assertEquals((int)1, (int)ruleElementSelector.getTailMatchLength(p));
        p = new ElementPath("/a/B");
        ruleElementSelector = new ElementSelector("*/b");
        Assertions.assertEquals((int)1, (int)ruleElementSelector.getTailMatchLength(p));
        p = new ElementPath("/a/b/c");
        ruleElementSelector = new ElementSelector("*/b/c");
        Assertions.assertEquals((int)2, (int)ruleElementSelector.getTailMatchLength(p));
    }

    @Test
    public void testPrefixMatch() {
        ElementPath p = new ElementPath("/a/b");
        ElementSelector ruleElementSelector = new ElementSelector("/x/*");
        Assertions.assertEquals((int)0, (int)ruleElementSelector.getPrefixMatchLength(p));
        p = new ElementPath("/a");
        ruleElementSelector = new ElementSelector("/x/*");
        Assertions.assertEquals((int)0, (int)ruleElementSelector.getPrefixMatchLength(p));
        p = new ElementPath("/a/b");
        ruleElementSelector = new ElementSelector("/a/*");
        Assertions.assertEquals((int)1, (int)ruleElementSelector.getPrefixMatchLength(p));
        p = new ElementPath("/a/b");
        ruleElementSelector = new ElementSelector("/A/*");
        Assertions.assertEquals((int)1, (int)ruleElementSelector.getPrefixMatchLength(p));
        p = new ElementPath("/A/b");
        ruleElementSelector = new ElementSelector("/a/*");
        Assertions.assertEquals((int)1, (int)ruleElementSelector.getPrefixMatchLength(p));
        p = new ElementPath("/a/b");
        ruleElementSelector = new ElementSelector("/a/b/*");
        Assertions.assertEquals((int)2, (int)ruleElementSelector.getPrefixMatchLength(p));
        p = new ElementPath("/a/b");
        ruleElementSelector = new ElementSelector("/*");
        Assertions.assertEquals((int)0, (int)ruleElementSelector.getPrefixMatchLength(p));
    }
}

