/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import ch.qos.logback.core.helpers.CyclicBuffer;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CyclicBufferTest {
    void assertSize(CyclicBuffer<String> cb, int size) {
        Assertions.assertEquals((int)size, (int)cb.length());
    }

    @Test
    public void smoke() {
        CyclicBuffer cb = new CyclicBuffer(2);
        this.assertSize((CyclicBuffer<String>)cb, 0);
        cb.add((Object)"zero");
        this.assertSize((CyclicBuffer<String>)cb, 1);
        cb.add((Object)"one");
        this.assertSize((CyclicBuffer<String>)cb, 2);
        cb.add((Object)"two");
        this.assertSize((CyclicBuffer<String>)cb, 2);
        Assertions.assertEquals((Object)"one", (Object)cb.get());
        this.assertSize((CyclicBuffer<String>)cb, 1);
        Assertions.assertEquals((Object)"two", (Object)cb.get());
        this.assertSize((CyclicBuffer<String>)cb, 0);
    }

    @Test
    public void cloning() {
        CyclicBuffer cb = new CyclicBuffer(2);
        cb.add((Object)"zero");
        cb.add((Object)"one");
        CyclicBuffer clone = new CyclicBuffer(cb);
        this.assertSize((CyclicBuffer<String>)clone, 2);
        cb.clear();
        this.assertSize((CyclicBuffer<String>)cb, 0);
        List<String> witness = Arrays.asList("zero", "one");
        Assertions.assertEquals(witness, (Object)clone.asList());
    }
}

