/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.boolex;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.boolex.Matcher;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MatcherTest {
    Context context;
    Matcher matcher;

    @BeforeEach
    public void setUp() throws Exception {
        this.context = new ContextBase();
        this.matcher = new Matcher();
        this.matcher.setContext(this.context);
        this.matcher.setName("testMatcher");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.matcher = null;
    }

    @Test
    public void testFullRegion() throws Exception {
        this.matcher.setRegex(".*test.*");
        this.matcher.start();
        Assertions.assertTrue((boolean)this.matcher.matches("test"));
        Assertions.assertTrue((boolean)this.matcher.matches("xxxxtest"));
        Assertions.assertTrue((boolean)this.matcher.matches("testxxxx"));
        Assertions.assertTrue((boolean)this.matcher.matches("xxxxtestxxxx"));
    }

    public void testPartRegion() throws Exception {
        this.matcher.setRegex("test");
        this.matcher.start();
        Assertions.assertTrue((boolean)this.matcher.matches("test"));
        Assertions.assertTrue((boolean)this.matcher.matches("xxxxtest"));
        Assertions.assertTrue((boolean)this.matcher.matches("testxxxx"));
        Assertions.assertTrue((boolean)this.matcher.matches("xxxxtestxxxx"));
    }

    public void testCaseInsensitive() throws Exception {
        this.matcher.setRegex("test");
        this.matcher.setCaseSensitive(false);
        this.matcher.start();
        Assertions.assertTrue((boolean)this.matcher.matches("TEST"));
        Assertions.assertTrue((boolean)this.matcher.matches("tEst"));
        Assertions.assertTrue((boolean)this.matcher.matches("tESt"));
        Assertions.assertTrue((boolean)this.matcher.matches("TesT"));
    }

    public void testCaseSensitive() throws Exception {
        this.matcher.setRegex("test");
        this.matcher.setCaseSensitive(true);
        this.matcher.start();
        Assertions.assertFalse((boolean)this.matcher.matches("TEST"));
        Assertions.assertFalse((boolean)this.matcher.matches("tEst"));
        Assertions.assertFalse((boolean)this.matcher.matches("tESt"));
        Assertions.assertFalse((boolean)this.matcher.matches("TesT"));
    }
}

