/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.encoder.DummyEncoder;
import ch.qos.logback.core.encoder.NopEncoder;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.File;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FileAppenderTest
extends AbstractAppenderTest<Object> {
    int diff = RandomUtil.getPositiveInt();

    @Override
    protected Appender<Object> getAppender() {
        return new FileAppender();
    }

    @Override
    protected Appender<Object> getConfiguredAppender() {
        FileAppender appender = new FileAppender();
        appender.setEncoder(new NopEncoder());
        appender.setFile("target/test-output/temp.log");
        appender.setName("test");
        appender.setContext(this.context);
        appender.start();
        return appender;
    }

    @Test
    public void smoke() {
        String filename = "target/test-output//fat-smoke.log";
        FileAppender appender = new FileAppender();
        appender.setEncoder(new DummyEncoder());
        appender.setAppend(false);
        appender.setFile(filename);
        appender.setName("smoke");
        appender.setContext(this.context);
        appender.start();
        appender.doAppend(new Object());
        appender.stop();
        File file = new File(filename);
        Assertions.assertTrue((boolean)file.exists());
        Assertions.assertTrue((boolean)file.delete(), (String)("failed to delete " + file.getAbsolutePath()));
    }

    @Test
    public void testCreateParentFolders() {
        String filename = "target/test-output//fat-testCreateParentFolders-" + this.diff + "/testCreateParentFolders.txt";
        File file = new File(filename);
        Assertions.assertFalse((boolean)file.getParentFile().exists());
        Assertions.assertFalse((boolean)file.exists());
        FileAppender appender = new FileAppender();
        appender.setEncoder(new DummyEncoder());
        appender.setAppend(false);
        appender.setFile(filename);
        appender.setName("testCreateParentFolders");
        appender.setContext(this.context);
        appender.start();
        appender.doAppend(new Object());
        appender.stop();
        Assertions.assertTrue((boolean)file.getParentFile().exists());
        Assertions.assertTrue((boolean)file.exists());
        Assertions.assertTrue((boolean)file.delete(), (String)("failed to delete " + file.getAbsolutePath()));
        File parent = file.getParentFile();
        Assertions.assertTrue((boolean)parent.delete(), (String)("failed to delete " + parent.getAbsolutePath()));
    }

    @Test
    public void testPrudentModeLogicalImplications() {
        String filename = "target/test-output/" + this.diff + "fat-testPrudentModeLogicalImplications.txt";
        File file = new File(filename);
        FileAppender appender = new FileAppender();
        appender.setEncoder(new DummyEncoder());
        appender.setFile(filename);
        appender.setName("testPrudentModeLogicalImplications");
        appender.setContext(this.context);
        appender.setAppend(false);
        appender.setPrudent(true);
        appender.start();
        Assertions.assertTrue((boolean)appender.isAppend());
        StatusManager sm = this.context.getStatusManager();
        StatusChecker statusChecker = new StatusChecker(this.context);
        Assertions.assertEquals((int)1, (int)statusChecker.getHighestLevel(0L));
        List statusList = sm.getCopyOfStatusList();
        Assertions.assertTrue((statusList.size() >= 2 ? 1 : 0) != 0, (String)("Expecting status list size to be 2 or larger, but was " + statusList.size()));
        String msg1 = ((Status)statusList.get(1)).getMessage();
        Assertions.assertTrue((boolean)msg1.startsWith("Setting \"Append\" property"), (String)("Got message [" + msg1 + "]"));
        appender.doAppend(new Object());
        appender.stop();
        Assertions.assertTrue((boolean)file.exists());
        Assertions.assertTrue((boolean)file.delete(), (String)("failed to delete " + file.getAbsolutePath()));
    }

    @Test
    public void fileNameCollision() {
        String fileName = "target/test-output/" + this.diff + "fileNameCollision";
        FileAppender appender0 = new FileAppender();
        appender0.setName("FA0");
        appender0.setFile(fileName);
        appender0.setContext(this.context);
        appender0.setEncoder(new DummyEncoder());
        appender0.start();
        Assertions.assertTrue((boolean)appender0.isStarted());
        FileAppender appender1 = new FileAppender();
        appender1.setName("FA1");
        appender1.setFile(fileName);
        appender1.setContext(this.context);
        appender1.setEncoder(new DummyEncoder());
        appender1.start();
        Assertions.assertFalse((boolean)appender1.isStarted());
        StatusPrinter.print((Context)this.context);
        StatusChecker checker = new StatusChecker(this.context);
        checker.assertContainsMatch(2, "'File' option has the same value");
    }
}

