/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractAppenderTest<E> {
    Context context = new ContextBase();

    protected abstract Appender<E> getAppender();

    protected abstract Appender<E> getConfiguredAppender();

    @Test
    public void testNewAppender() {
        Appender<E> appender = this.getAppender();
        Assertions.assertFalse((boolean)appender.isStarted());
    }

    @Test
    public void testConfiguredAppender() {
        Appender<E> appender = this.getConfiguredAppender();
        appender.start();
        Assertions.assertTrue((boolean)appender.isStarted());
        appender.stop();
        Assertions.assertFalse((boolean)appender.isStarted());
    }

    @Test
    public void testNoStart() {
        Appender<E> appender = this.getAppender();
        appender.setContext(this.context);
        appender.setName("doh");
        appender.doAppend(null);
        StatusChecker checker = new StatusChecker(this.context.getStatusManager());
        StatusPrinter.print((Context)this.context);
        checker.assertContainsMatch("Attempted to append to non started appender \\[doh\\].");
    }
}

