/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.ContextBase;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.encoder.EchoEncoder;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.recovery.RecoveryListener;
import ch.qos.logback.core.recovery.ResilientFileOutputStream;
import ch.qos.logback.core.status.OnConsoleStatusListener;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.ResilienceUtil;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class FileAppenderResilienceTest
implements RecoveryListener {
    FileAppender<Object> fa = new FileAppender();
    ResilientFileOutputStream resilientFOS;
    Context context = new ContextBase();
    int diff = RandomUtil.getPositiveInt();
    String outputDirStr = "target/test-output/resilience-" + this.diff + "/";
    String logfileStr = this.outputDirStr + "output.log";
    boolean failedState = false;
    int recoveryCounter = 0;
    int failureCounter = 0;

    @BeforeEach
    public void setUp() throws InterruptedException {
        this.context.getStatusManager().add((StatusListener)new OnConsoleStatusListener());
        File outputDir = new File(this.outputDirStr);
        outputDir.mkdirs();
        this.fa.setContext(this.context);
        this.fa.setName("FILE");
        this.fa.setEncoder((Encoder)new EchoEncoder());
        this.fa.setFile(this.logfileStr);
        this.fa.start();
        this.resilientFOS = (ResilientFileOutputStream)this.fa.getOutputStream();
        this.resilientFOS.addRecoveryListener((RecoveryListener)this);
    }

    @Test
    @Disabled
    public void manual() throws InterruptedException, IOException {
        Runner runner = new Runner(this.fa);
        Thread t = new Thread(runner);
        t.start();
        while (true) {
            Thread.sleep(110L);
        }
    }

    @Test
    public void smoke() throws InterruptedException, IOException {
        Runner runner = new Runner(this.fa);
        Thread t = new Thread(runner);
        t.start();
        double delayCoefficient = 2.0;
        for (int i = 0; i < 5; ++i) {
            Thread.sleep((int)(20.0 * delayCoefficient));
            this.closeLogFileOnPurpose();
        }
        runner.setDone(true);
        t.join();
        double bestCaseSuccessRatio = 1.0 / delayCoefficient;
        double lossinessFactor = 0.35;
        double resilianceFactor = 1.0 - lossinessFactor;
        Assertions.assertTrue((this.recoveryCounter > 0 ? 1 : 0) != 0, (String)"at least one recovery should have occured");
        Assertions.assertTrue((this.failureCounter > 0 ? 1 : 0) != 0, (String)"at least one failure should have occured");
        System.out.println("recoveryCounter=" + this.recoveryCounter);
        System.out.println("failureCounter=" + this.failureCounter);
        String errmsg0 = "failureCounter=" + this.failureCounter + " must be greater or equal to recoveryCounter=" + this.recoveryCounter;
        Assertions.assertTrue((this.failureCounter >= this.recoveryCounter ? 1 : 0) != 0, (String)errmsg0);
        String errmsg1 = "Difference between failureCounter=" + this.failureCounter + " and recoveryCounter=" + this.recoveryCounter + " should not exceeed 1";
        Assertions.assertTrue((this.failureCounter - this.recoveryCounter <= 1 ? 1 : 0) != 0, (String)errmsg1);
        int actuallyWritten = ResilienceUtil.countLines(this.logfileStr, "^hello (\\d{1,5})$");
        long exptectedWrites = runner.getCounter() - (long)this.recoveryCounter;
        Assertions.assertEquals((long)exptectedWrites, (long)actuallyWritten);
    }

    private void closeLogFileOnPurpose() throws IOException {
        ResilientFileOutputStream resilientFOS = (ResilientFileOutputStream)this.fa.getOutputStream();
        FileChannel fileChannel = resilientFOS.getChannel();
        fileChannel.close();
    }

    public void newFailure(IOException e) {
        this.failedState = true;
        ++this.failureCounter;
    }

    public void recoveryOccured() {
        this.failedState = false;
        ++this.recoveryCounter;
    }

    class Runner
    extends RunnableWithCounterAndDone {
        FileAppender<Object> fa;

        Runner(FileAppender<Object> fa) {
            this.fa = fa;
        }

        @Override
        public void run() {
            while (!this.isDone()) {
                this.fa.doAppend((Object)("hello " + this.counter));
                if (!FileAppenderResilienceTest.this.failedState) {
                    ++this.counter;
                }
                if (this.counter % 128L != 0L) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

