/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Model
implements Serializable {
    private static final long serialVersionUID = -797372668713068159L;
    boolean handled = false;
    boolean skipped = false;
    String tag;
    String bodyText;
    int lineNumber;
    List<Model> subModels = new ArrayList<Model>();

    public void markAsSkipped() {
        this.skipped = true;
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public boolean isUnhandled() {
        return !this.handled;
    }

    public boolean isHandled() {
        return this.handled;
    }

    public void markAsHandled() {
        this.handled = true;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public List<Model> getSubModels() {
        return this.subModels;
    }

    public void addSubModel(Model m) {
        this.subModels.add(m);
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public void addText(String bodytext) {
        this.bodyText = this.bodyText == null ? bodytext : String.valueOf(this.bodyText) + bodytext;
    }

    public String idString() {
        return "<" + this.tag + "> at line " + this.lineNumber;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " [tag=" + this.tag + ", bodyText=" + this.bodyText + "]";
    }
}

