/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.ImplicitActionDataBase;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.spi.SaxEventInterpreter;
import ch.qos.logback.core.joran.util.beans.BeanDescriptionCache;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Locator;

public class InterpretationContext
extends ContextAwareBase
implements PropertyContainer {
    Stack<Object> objectStack;
    Stack<Model> modelStack;
    Stack<ImplicitActionDataBase> implicitActionDataStack;
    Map<String, Object> objectMap;
    Map<String, String> propertiesMap;
    final HashMap<Model, List<String>> dependenciesMap = new HashMap();
    final List<String> startedDependencies = new ArrayList<String>();
    SaxEventInterpreter saxEventInterpreter;
    DefaultNestedComponentRegistry defaultNestedComponentRegistry = new DefaultNestedComponentRegistry();
    private BeanDescriptionCache beanDescriptionCache;

    public InterpretationContext(Context context, SaxEventInterpreter saxEventInterpreter) {
        this.context = context;
        this.saxEventInterpreter = saxEventInterpreter;
        this.objectStack = new Stack();
        this.modelStack = new Stack();
        this.implicitActionDataStack = new Stack();
        this.objectMap = new HashMap<String, Object>(5);
        this.propertiesMap = new HashMap<String, String>(5);
    }

    public BeanDescriptionCache getBeanDescriptionCache() {
        if (this.beanDescriptionCache == null) {
            this.beanDescriptionCache = new BeanDescriptionCache(this.getContext());
        }
        return this.beanDescriptionCache;
    }

    public DefaultNestedComponentRegistry getDefaultNestedComponentRegistry() {
        return this.defaultNestedComponentRegistry;
    }

    @Override
    public Map<String, String> getCopyOfPropertyMap() {
        return new HashMap<String, String>(this.propertiesMap);
    }

    void setPropertiesMap(Map<String, String> propertiesMap) {
        this.propertiesMap = propertiesMap;
    }

    public HashMap<Model, List<String>> getDependenciesMap() {
        return this.dependenciesMap;
    }

    public boolean hasDependencies(String name) {
        Collection<List<String>> nameLists = this.dependenciesMap.values();
        if (nameLists == null || nameLists.isEmpty()) {
            return false;
        }
        for (List<String> aList : nameLists) {
            if (!aList.contains(name)) continue;
            return true;
        }
        return false;
    }

    public void addDependency(Model model, String ref) {
        List<String> refList = this.dependenciesMap.get(model);
        if (refList == null) {
            refList = new ArrayList<String>();
        }
        refList.add(ref);
        this.dependenciesMap.put(model, refList);
    }

    public List<String> getDependencies(Model model) {
        return this.dependenciesMap.get(model);
    }

    String updateLocationInfo(String msg) {
        Locator locator = this.saxEventInterpreter.getLocator();
        if (locator != null) {
            return msg + locator.getLineNumber() + ":" + locator.getColumnNumber();
        }
        return msg;
    }

    public String getLineNumber() {
        Locator locator = this.saxEventInterpreter.getLocator();
        if (locator != null) {
            return Integer.toString(locator.getLineNumber());
        }
        return "NA";
    }

    public Locator getLocator() {
        return this.saxEventInterpreter.getLocator();
    }

    public SaxEventInterpreter getSaxEventInterpreter() {
        return this.saxEventInterpreter;
    }

    public Stack<Object> getObjectStack() {
        return this.objectStack;
    }

    public boolean isEmpty() {
        return this.isObjectStackEmpty();
    }

    public boolean isObjectStackEmpty() {
        return this.objectStack.isEmpty();
    }

    public Object peekObject() {
        return this.objectStack.peek();
    }

    public void pushObject(Object o) {
        this.objectStack.push(o);
    }

    public Object popObject() {
        return this.objectStack.pop();
    }

    public Stack<ImplicitActionDataBase> getImplcitActionDataStack() {
        return this.implicitActionDataStack;
    }

    public Model peekModel() {
        return this.modelStack.peek();
    }

    public void pushModel(Model m) {
        this.modelStack.push(m);
    }

    public boolean isModelStackEmpty() {
        return this.modelStack.isEmpty();
    }

    public Model popModel() {
        return this.modelStack.pop();
    }

    public Stack<Model> getCopyOfModelStack() {
        Stack<Model> copy = new Stack<Model>();
        copy.addAll(this.modelStack);
        return copy;
    }

    public Object getObject(int i) {
        return this.objectStack.get(i);
    }

    public Map<String, Object> getObjectMap() {
        return this.objectMap;
    }

    public void addSubstitutionProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        value = value.trim();
        this.propertiesMap.put(key, value);
    }

    public void addSubstitutionProperties(Properties props) {
        if (props == null) {
            return;
        }
        for (Object keyObject : props.keySet()) {
            String key = (String)keyObject;
            String val = props.getProperty(key);
            this.addSubstitutionProperty(key, val);
        }
    }

    @Override
    public String getProperty(String key) {
        String v = this.propertiesMap.get(key);
        if (v != null) {
            return v;
        }
        return this.context.getProperty(key);
    }

    public String subst(String value) {
        if (value == null) {
            return null;
        }
        try {
            return OptionHelper.substVars(value, this, this.context);
        }
        catch (ScanException | IllegalArgumentException e) {
            this.addError("Problem while parsing [" + value + "]", e);
            return value;
        }
    }

    public void markStartOfNamedDependency(String name) {
        this.startedDependencies.add(name);
    }

    public boolean isNamedDependencyStarted(String name) {
        return this.startedDependencies.contains(name);
    }
}

