/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.joran.spi.ElementPath;
import ch.qos.logback.core.joran.spi.ElementSelector;
import org.junit.Assert;
import org.junit.Test;

public class ElementSelectorTest {
    @Test
    public void test1() {
        ElementSelector p = new ElementSelector("a");
        Assert.assertEquals((long)1L, (long)p.size());
        Assert.assertEquals((Object)"a", (Object)p.peekLast());
        Assert.assertEquals((Object)"a", (Object)p.get(0));
    }

    @Test
    public void testSuffix() {
        ElementSelector p = new ElementSelector("a/");
        Assert.assertEquals((long)1L, (long)p.size());
        Assert.assertEquals((Object)"a", (Object)p.peekLast());
        Assert.assertEquals((Object)"a", (Object)p.get(0));
    }

    @Test
    public void test2() {
        ElementSelector p = new ElementSelector("a/b");
        Assert.assertEquals((long)2L, (long)p.size());
        Assert.assertEquals((Object)"b", (Object)p.peekLast());
        Assert.assertEquals((Object)"a", (Object)p.get(0));
        Assert.assertEquals((Object)"b", (Object)p.get(1));
    }

    @Test
    public void test3() {
        ElementSelector p = new ElementSelector("a123/b1234/cvvsdf");
        Assert.assertEquals((long)3L, (long)p.size());
        Assert.assertEquals((Object)"a123", (Object)p.get(0));
        Assert.assertEquals((Object)"b1234", (Object)p.get(1));
        Assert.assertEquals((Object)"cvvsdf", (Object)p.get(2));
    }

    @Test
    public void test4() {
        ElementSelector p = new ElementSelector("/a123/b1234/cvvsdf");
        Assert.assertEquals((long)3L, (long)p.size());
        Assert.assertEquals((Object)"a123", (Object)p.get(0));
        Assert.assertEquals((Object)"b1234", (Object)p.get(1));
        Assert.assertEquals((Object)"cvvsdf", (Object)p.get(2));
    }

    @Test
    public void test5() {
        ElementSelector p = new ElementSelector("//a");
        Assert.assertEquals((long)1L, (long)p.size());
        Assert.assertEquals((Object)"a", (Object)p.get(0));
    }

    @Test
    public void test6() {
        ElementSelector p = new ElementSelector("//a//b");
        Assert.assertEquals((long)2L, (long)p.size());
        Assert.assertEquals((Object)"a", (Object)p.get(0));
        Assert.assertEquals((Object)"b", (Object)p.get(1));
    }

    @Test
    public void testTailMatch() {
        ElementPath p = new ElementPath("/a/b");
        ElementSelector ruleElementSelector = new ElementSelector("*");
        Assert.assertEquals((long)0L, (long)ruleElementSelector.getTailMatchLength(p));
        p = new ElementPath("/a");
        ruleElementSelector = new ElementSelector("*/a");
        Assert.assertEquals((long)1L, (long)ruleElementSelector.getTailMatchLength(p));
        p = new ElementPath("/A");
        ruleElementSelector = new ElementSelector("*/a");
        Assert.assertEquals((long)1L, (long)ruleElementSelector.getTailMatchLength(p));
        p = new ElementPath("/a");
        ruleElementSelector = new ElementSelector("*/A");
        Assert.assertEquals((long)1L, (long)ruleElementSelector.getTailMatchLength(p));
        p = new ElementPath("/a/b");
        ruleElementSelector = new ElementSelector("*/b");
        Assert.assertEquals((long)1L, (long)ruleElementSelector.getTailMatchLength(p));
        p = new ElementPath("/a/B");
        ruleElementSelector = new ElementSelector("*/b");
        Assert.assertEquals((long)1L, (long)ruleElementSelector.getTailMatchLength(p));
        p = new ElementPath("/a/b/c");
        ruleElementSelector = new ElementSelector("*/b/c");
        Assert.assertEquals((long)2L, (long)ruleElementSelector.getTailMatchLength(p));
    }

    @Test
    public void testPrefixMatch() {
        ElementPath p = new ElementPath("/a/b");
        ElementSelector ruleElementSelector = new ElementSelector("/x/*");
        Assert.assertEquals((long)0L, (long)ruleElementSelector.getPrefixMatchLength(p));
        p = new ElementPath("/a");
        ruleElementSelector = new ElementSelector("/x/*");
        Assert.assertEquals((long)0L, (long)ruleElementSelector.getPrefixMatchLength(p));
        p = new ElementPath("/a/b");
        ruleElementSelector = new ElementSelector("/a/*");
        Assert.assertEquals((long)1L, (long)ruleElementSelector.getPrefixMatchLength(p));
        p = new ElementPath("/a/b");
        ruleElementSelector = new ElementSelector("/A/*");
        Assert.assertEquals((long)1L, (long)ruleElementSelector.getPrefixMatchLength(p));
        p = new ElementPath("/A/b");
        ruleElementSelector = new ElementSelector("/a/*");
        Assert.assertEquals((long)1L, (long)ruleElementSelector.getPrefixMatchLength(p));
        p = new ElementPath("/a/b");
        ruleElementSelector = new ElementSelector("/a/b/*");
        Assert.assertEquals((long)2L, (long)ruleElementSelector.getPrefixMatchLength(p));
        p = new ElementPath("/a/b");
        ruleElementSelector = new ElementSelector("/*");
        Assert.assertEquals((long)0L, (long)ruleElementSelector.getPrefixMatchLength(p));
    }
}

