/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.util.DynamicClassLoadingException;
import ch.qos.logback.core.util.IncompatibleClassException;

public class OptionHelper {
    static final String DELIM_START = "${";
    static final char DELIM_STOP = '}';
    static final int DELIM_START_LEN = 2;
    static final int DELIM_STOP_LEN = 1;
    static final String _IS_UNDEFINED = "_IS_UNDEFINED";

    public static Object instantiateByClassName(String className, Class superClass, Context context) throws IncompatibleClassException, DynamicClassLoadingException {
        ClassLoader classLoader = context.getClass().getClassLoader();
        return OptionHelper.instantiateByClassName(className, superClass, classLoader);
    }

    public static Object instantiateByClassName(String className, Class superClass, ClassLoader classLoader) throws IncompatibleClassException, DynamicClassLoadingException {
        if (className == null) {
            throw new NullPointerException();
        }
        try {
            Class<?> classObj = null;
            classObj = classLoader.loadClass(className);
            if (!superClass.isAssignableFrom(classObj)) {
                throw new IncompatibleClassException(superClass, classObj);
            }
            return classObj.newInstance();
        }
        catch (IncompatibleClassException ice) {
            throw ice;
        }
        catch (Throwable t) {
            throw new DynamicClassLoadingException("Failed to instantiate type " + className, t);
        }
    }

    public static String substVars(String val, Context context) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (true) {
            int j;
            if ((j = val.indexOf(DELIM_START, i)) == -1) {
                if (i == 0) {
                    return val;
                }
                sbuf.append(val.substring(i, val.length()));
                return sbuf.toString();
            }
            sbuf.append(val.substring(i, j));
            int k = val.indexOf(125, j);
            if (k == -1) {
                throw new IllegalArgumentException('\"' + val + "\" has no closing brace. Opening brace at position " + j + '.');
            }
            String rawKey = val.substring(j += 2, k);
            String[] extracted = OptionHelper.extractDefaultReplacement(rawKey);
            String key = extracted[0];
            String defaultReplacement = extracted[1];
            String replacement = null;
            replacement = context.getProperty(key);
            if (replacement == null) {
                replacement = OptionHelper.getSystemProperty(key, null);
            }
            if (replacement == null) {
                replacement = defaultReplacement;
            }
            if (replacement != null) {
                String recursiveReplacement = OptionHelper.substVars(replacement, context);
                sbuf.append(recursiveReplacement);
            } else {
                sbuf.append(key + _IS_UNDEFINED);
            }
            i = k + 1;
        }
    }

    public static String getSystemProperty(String key, String def) {
        try {
            return System.getProperty(key, def);
        }
        catch (Throwable e) {
            return def;
        }
    }

    public static String[] extractDefaultReplacement(String key) {
        String[] result = new String[2];
        result[0] = key;
        int d = key.indexOf(":-");
        if (d != -1) {
            result[0] = key.substring(0, d);
            result[1] = key.substring(d + 2);
        }
        return result;
    }

    public static boolean toBoolean(String value, boolean dEfault) {
        if (value == null) {
            return dEfault;
        }
        String trimmedVal = value.trim();
        if ("true".equalsIgnoreCase(trimmedVal)) {
            return true;
        }
        if ("false".equalsIgnoreCase(trimmedVal)) {
            return false;
        }
        return dEfault;
    }

    public static boolean isEmpty(String val) {
        return val == null || "".equals(val);
    }
}

