/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.ScanException;
import ch.qos.logback.core.pattern.util.EscapeUtil;
import java.util.ArrayList;
import java.util.List;

public class OptionTokenizer {
    private static final int EXPECTING_STATE = 0;
    private static final int COLLECTING_STATE = 1;
    private static final int QUOTED_COLLECTING_STATE = 2;
    private static final char ESCAPE_CHAR = '\\';
    private static final char COMMA_CHAR = ',';
    private static final char DOUBLE_QUOTE_CHAR = '\"';
    private static final char SINGLE_QUOTE_CHAR = '\'';
    String pattern;
    int patternLength;
    char quoteChar;
    int pointer = 0;
    int state = 0;

    OptionTokenizer(String pattern) {
        this.pattern = pattern;
        this.patternLength = pattern.length();
    }

    List tokenize() throws ScanException {
        ArrayList<String> tokenList = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        while (this.pointer < this.patternLength) {
            char c = this.pattern.charAt(this.pointer);
            ++this.pointer;
            block0 : switch (this.state) {
                case 0: {
                    switch (c) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            break block0;
                        }
                        case '\"': 
                        case '\'': {
                            this.state = 2;
                            this.quoteChar = c;
                            break block0;
                        }
                    }
                    buf.append(c);
                    this.state = 1;
                    break;
                }
                case 1: {
                    switch (c) {
                        case ',': {
                            tokenList.add(buf.toString().trim());
                            buf.setLength(0);
                            this.state = 0;
                            break block0;
                        }
                    }
                    buf.append(c);
                    break;
                }
                case 2: {
                    if (c == this.quoteChar) {
                        tokenList.add(buf.toString());
                        buf.setLength(0);
                        this.state = 0;
                        break;
                    }
                    if (c == '\\') {
                        this.escape(String.valueOf(this.quoteChar), buf);
                        break;
                    }
                    buf.append(c);
                }
            }
        }
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                tokenList.add(buf.toString().trim());
                break;
            }
            default: {
                throw new ScanException("Unexpected end of pattern string");
            }
        }
        return tokenList;
    }

    void escape(String escapeChars, StringBuffer buf) {
        if (this.pointer < this.patternLength) {
            char next = this.pattern.charAt(this.pointer++);
            EscapeUtil.escape(escapeChars, buf, next, this.pointer);
        }
    }
}

