/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.joran;

import ch.qos.logback.access.PatternLayout;
import ch.qos.logback.access.PatternLayoutEncoder;
import ch.qos.logback.access.boolex.JaninoEventEvaluator;
import ch.qos.logback.access.joran.action.ConfigurationAction;
import ch.qos.logback.access.model.ConfigurationModel;
import ch.qos.logback.access.model.processor.ConfigurationModelHandler;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.filter.EvaluatorFilter;
import ch.qos.logback.core.joran.JoranConfiguratorBase;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.action.AppenderRefAction;
import ch.qos.logback.core.joran.action.IncludeModelAction;
import ch.qos.logback.core.joran.spi.DefaultNestedComponentRegistry;
import ch.qos.logback.core.joran.spi.ElementSelector;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.model.AppenderModel;
import ch.qos.logback.core.model.AppenderRefModel;
import ch.qos.logback.core.model.DefineModel;
import ch.qos.logback.core.model.EventEvaluatorModel;
import ch.qos.logback.core.model.ImplicitModel;
import ch.qos.logback.core.model.IncludeModel;
import ch.qos.logback.core.model.ParamModel;
import ch.qos.logback.core.model.PropertyModel;
import ch.qos.logback.core.model.ShutdownHookModel;
import ch.qos.logback.core.model.TimestampModel;
import ch.qos.logback.core.model.processor.AllowAllModelFilter;
import ch.qos.logback.core.model.processor.AppenderModelHandler;
import ch.qos.logback.core.model.processor.AppenderRefModelHandler;
import ch.qos.logback.core.model.processor.ChainedModelFilter;
import ch.qos.logback.core.model.processor.DefaultProcessor;
import ch.qos.logback.core.model.processor.ModelFiler;
import ch.qos.logback.core.net.ssl.SSLNestedComponentRegistryRules;

public class JoranConfigurator
extends JoranConfiguratorBase<IAccessEvent> {
    public void addInstanceRules(RuleStore rs) {
        super.addInstanceRules(rs);
        rs.addRule(new ElementSelector("configuration"), (Action)new ConfigurationAction());
        rs.addRule(new ElementSelector("configuration/appender-ref"), (Action)new AppenderRefAction());
        rs.addRule(new ElementSelector("configuration/include"), (Action)new IncludeModelAction());
    }

    protected DefaultProcessor buildDefaultProcessor(Context context, InterpretationContext interpretationContext) {
        DefaultProcessor defaultProcessor = super.buildDefaultProcessor(context, interpretationContext);
        defaultProcessor.addHandler(ConfigurationModel.class, ConfigurationModelHandler.class);
        defaultProcessor.addHandler(AppenderModel.class, AppenderModelHandler.class);
        defaultProcessor.addHandler(AppenderRefModel.class, AppenderRefModelHandler.class);
        this.injectModelFilters(defaultProcessor);
        return defaultProcessor;
    }

    private void injectModelFilters(DefaultProcessor defaultProcessor) {
        Class[] variableDefinitionModelClasses = new Class[]{DefineModel.class, PropertyModel.class, TimestampModel.class, ParamModel.class};
        Class[] implicitModelClasses = new Class[]{ImplicitModel.class, ParamModel.class};
        Class[] appenderRefModelClasses = new Class[]{AppenderRefModel.class};
        Class[] otherFirstPhaseModelClasses = new Class[]{ConfigurationModel.class, EventEvaluatorModel.class, ShutdownHookModel.class, EventEvaluatorModel.class, IncludeModel.class};
        ChainedModelFilter fistPhaseDefintionFilter = new ChainedModelFilter();
        for (Class modelClass : variableDefinitionModelClasses) {
            fistPhaseDefintionFilter.allow(modelClass);
        }
        for (Class modelClass : otherFirstPhaseModelClasses) {
            fistPhaseDefintionFilter.allow(modelClass);
        }
        for (Class modelClass : implicitModelClasses) {
            fistPhaseDefintionFilter.allow(modelClass);
        }
        for (Class modelClass : appenderRefModelClasses) {
            fistPhaseDefintionFilter.allow(modelClass);
        }
        fistPhaseDefintionFilter.denyAll();
        defaultProcessor.setPhaseOneFilter((ModelFiler)fistPhaseDefintionFilter);
        defaultProcessor.setPhaseTwoFilter((ModelFiler)new AllowAllModelFilter());
    }

    protected void addDefaultNestedComponentRegistryRules(DefaultNestedComponentRegistry registry) {
        registry.add(AppenderBase.class, "layout", PatternLayout.class);
        registry.add(EvaluatorFilter.class, "evaluator", JaninoEventEvaluator.class);
        registry.add(AppenderBase.class, "encoder", PatternLayoutEncoder.class);
        registry.add(UnsynchronizedAppenderBase.class, "encoder", PatternLayoutEncoder.class);
        SSLNestedComponentRegistryRules.addDefaultNestedComponentRegistryRules((DefaultNestedComponentRegistry)registry);
    }
}

