/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.mongodb;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.contrib.mongodb.MongoDBAppenderBase;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.util.Date;

public class MongoDBLoggingEventAppender
extends MongoDBAppenderBase<ILoggingEvent> {
    private boolean includeCallerData;

    protected BasicDBObject toMongoDocument(ILoggingEvent iLoggingEvent) {
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.append("message", (Object)iLoggingEvent.getFormattedMessage());
        basicDBObject.append("logger", (Object)iLoggingEvent.getLoggerName());
        basicDBObject.append("thread", (Object)iLoggingEvent.getThreadName());
        basicDBObject.append("timestamp", (Object)new Date(iLoggingEvent.getTimeStamp()));
        basicDBObject.append("level", (Object)iLoggingEvent.getLevel().toString());
        if (iLoggingEvent.getMDCPropertyMap() != null && !iLoggingEvent.getMDCPropertyMap().isEmpty()) {
            basicDBObject.append("mdc", (Object)iLoggingEvent.getMDCPropertyMap());
        }
        if (this.includeCallerData) {
            basicDBObject.append("callerData", (Object)this.toDocument(iLoggingEvent.getCallerData()));
        }
        if (iLoggingEvent.getArgumentArray() != null && iLoggingEvent.getArgumentArray().length > 0) {
            basicDBObject.append("arguments", (Object)iLoggingEvent.getArgumentArray());
        }
        this.appendThrowableIfAvailable(basicDBObject, iLoggingEvent);
        return basicDBObject;
    }

    private BasicDBList toDocument(StackTraceElement[] stackTraceElementArray) {
        BasicDBList basicDBList = new BasicDBList();
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            basicDBList.add((Object)new BasicDBObject().append("file", (Object)stackTraceElement.getFileName()).append("class", (Object)stackTraceElement.getClassName()).append("method", (Object)stackTraceElement.getMethodName()).append("line", (Object)stackTraceElement.getLineNumber()).append("native", (Object)stackTraceElement.isNativeMethod()));
        }
        return basicDBList;
    }

    private void appendThrowableIfAvailable(BasicDBObject basicDBObject, ILoggingEvent iLoggingEvent) {
        if (iLoggingEvent.getThrowableProxy() != null) {
            BasicDBObject basicDBObject2 = this.toMongoDocument(iLoggingEvent.getThrowableProxy());
            basicDBObject.append("throwable", (Object)basicDBObject2);
        }
    }

    private BasicDBObject toMongoDocument(IThrowableProxy iThrowableProxy) {
        BasicDBObject basicDBObject = new BasicDBObject();
        basicDBObject.append("class", (Object)iThrowableProxy.getClassName());
        basicDBObject.append("message", (Object)iThrowableProxy.getMessage());
        basicDBObject.append("stackTrace", (Object)this.toSteArray(iThrowableProxy));
        if (iThrowableProxy.getCause() != null) {
            basicDBObject.append("cause", (Object)this.toMongoDocument(iThrowableProxy.getCause()));
        }
        return basicDBObject;
    }

    private String[] toSteArray(IThrowableProxy iThrowableProxy) {
        StackTraceElementProxy[] stackTraceElementProxyArray = iThrowableProxy.getStackTraceElementProxyArray();
        int n = stackTraceElementProxyArray.length - iThrowableProxy.getCommonFrames();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stackTraceElementProxyArray[i].getStackTraceElement().toString();
        }
        return stringArray;
    }

    public void setIncludeCallerData(boolean bl) {
        this.includeCallerData = bl;
    }
}

