/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.json.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.contrib.json.JsonLayoutBase;
import java.util.LinkedHashMap;
import java.util.Map;

public class JsonLayout
extends JsonLayoutBase<ILoggingEvent> {
    public static final String TIMESTAMP_ATTR_NAME = "timestamp";
    public static final String LEVEL_ATTR_NAME = "level";
    public static final String THREAD_ATTR_NAME = "thread";
    public static final String MDC_ATTR_NAME = "mdc";
    public static final String LOGGER_ATTR_NAME = "logger";
    public static final String FORMATTED_MESSAGE_ATTR_NAME = "message";
    public static final String MESSAGE_ATTR_NAME = "raw-message";
    public static final String EXCEPTION_ATTR_NAME = "exception";
    public static final String CONTEXT_ATTR_NAME = "context";
    protected boolean includeLevel = true;
    protected boolean includeThreadName = true;
    protected boolean includeMDC = true;
    protected boolean includeLoggerName = true;
    protected boolean includeFormattedMessage = true;
    protected boolean includeMessage;
    protected boolean includeException = true;
    protected boolean includeContextName = true;
    private final ThrowableProxyConverter throwableProxyConverter = new ThrowableProxyConverter();

    public void start() {
        this.throwableProxyConverter.start();
        super.start();
    }

    public void stop() {
        super.stop();
        this.throwableProxyConverter.stop();
    }

    protected Map toJsonMap(ILoggingEvent iLoggingEvent) {
        IThrowableProxy iThrowableProxy;
        String string;
        String string2;
        String string3;
        String string4;
        Map map;
        String string5;
        String string6;
        Level level;
        long l;
        String string7;
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        if (this.includeTimestamp && (string7 = this.formatTimestamp(l = iLoggingEvent.getTimeStamp())) != null) {
            linkedHashMap.put(TIMESTAMP_ATTR_NAME, string7);
        }
        if (this.includeLevel && (level = iLoggingEvent.getLevel()) != null) {
            string6 = String.valueOf(level);
            linkedHashMap.put(LEVEL_ATTR_NAME, string6);
        }
        if (this.includeThreadName && (string5 = iLoggingEvent.getThreadName()) != null) {
            linkedHashMap.put(THREAD_ATTR_NAME, string5);
        }
        if (this.includeMDC && (map = iLoggingEvent.getMDCPropertyMap()) != null && !map.isEmpty()) {
            linkedHashMap.put(MDC_ATTR_NAME, map);
        }
        if (this.includeLoggerName && (string4 = iLoggingEvent.getLoggerName()) != null) {
            linkedHashMap.put(LOGGER_ATTR_NAME, string4);
        }
        if (this.includeFormattedMessage && (string3 = iLoggingEvent.getFormattedMessage()) != null) {
            linkedHashMap.put(FORMATTED_MESSAGE_ATTR_NAME, string3);
        }
        if (this.includeMessage && (string2 = iLoggingEvent.getMessage()) != null) {
            linkedHashMap.put(MESSAGE_ATTR_NAME, string2);
        }
        if (this.includeContextName && (string = iLoggingEvent.getLoggerContextVO().getName()) != null) {
            linkedHashMap.put(CONTEXT_ATTR_NAME, string);
        }
        if (this.includeException && (iThrowableProxy = iLoggingEvent.getThrowableProxy()) != null && (string6 = this.throwableProxyConverter.convert(iLoggingEvent)) != null && !string6.equals("")) {
            linkedHashMap.put(EXCEPTION_ATTR_NAME, string6);
        }
        this.addCustomDataToJsonMap(linkedHashMap, iLoggingEvent);
        return linkedHashMap;
    }

    protected void addCustomDataToJsonMap(Map<String, Object> map, ILoggingEvent iLoggingEvent) {
    }

    public boolean isIncludeLevel() {
        return this.includeLevel;
    }

    public void setIncludeLevel(boolean bl) {
        this.includeLevel = bl;
    }

    public boolean isIncludeLoggerName() {
        return this.includeLoggerName;
    }

    public void setIncludeLoggerName(boolean bl) {
        this.includeLoggerName = bl;
    }

    public boolean isIncludeFormattedMessage() {
        return this.includeFormattedMessage;
    }

    public void setIncludeFormattedMessage(boolean bl) {
        this.includeFormattedMessage = bl;
    }

    public boolean isIncludeMessage() {
        return this.includeMessage;
    }

    public void setIncludeMessage(boolean bl) {
        this.includeMessage = bl;
    }

    public boolean isIncludeMDC() {
        return this.includeMDC;
    }

    public void setIncludeMDC(boolean bl) {
        this.includeMDC = bl;
    }

    public boolean isIncludeThreadName() {
        return this.includeThreadName;
    }

    public void setIncludeThreadName(boolean bl) {
        this.includeThreadName = bl;
    }

    public boolean isIncludeException() {
        return this.includeException;
    }

    public void setIncludeException(boolean bl) {
        this.includeException = bl;
    }

    public boolean isIncludeContextName() {
        return this.includeContextName;
    }

    public void setIncludeContextName(boolean bl) {
        this.includeContextName = bl;
    }
}

