/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.contrib.json.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.contrib.json.JsonLayoutBase;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonLayout
extends JsonLayoutBase<ILoggingEvent> {
    public static final String TIMESTAMP_ATTR_NAME = "timestamp";
    public static final String LEVEL_ATTR_NAME = "level";
    public static final String THREAD_ATTR_NAME = "thread";
    public static final String MDC_ATTR_NAME = "mdc";
    public static final String LOGGER_ATTR_NAME = "logger";
    public static final String FORMATTED_MESSAGE_ATTR_NAME = "message";
    public static final String MESSAGE_ATTR_NAME = "raw-message";
    public static final String EXCEPTION_ATTR_NAME = "exception";
    public static final String CONTEXT_ATTR_NAME = "context";
    protected boolean includeLevel = true;
    protected boolean includeThreadName = true;
    protected boolean includeMDC = true;
    protected boolean includeLoggerName = true;
    protected boolean includeFormattedMessage = true;
    protected boolean includeMessage;
    protected boolean includeException = true;
    protected boolean includeContextName = true;
    private final ThrowableProxyConverter throwableProxyConverter = new ThrowableProxyConverter();

    public void start() {
        this.throwableProxyConverter.start();
        super.start();
    }

    public void stop() {
        super.stop();
        this.throwableProxyConverter.stop();
    }

    protected Map toJsonMap(ILoggingEvent event) {
        String ex;
        IThrowableProxy throwableProxy;
        String msg;
        String loggerName;
        Map mdc;
        String threadName;
        Level level;
        long timestamp;
        String formatted;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.includeTimestamp && (formatted = this.formatTimestamp(timestamp = event.getTimeStamp())) != null) {
            map.put(TIMESTAMP_ATTR_NAME, formatted);
        }
        if (this.includeLevel && (level = event.getLevel()) != null) {
            String lvlString = String.valueOf(level);
            map.put(LEVEL_ATTR_NAME, lvlString);
        }
        if (this.includeThreadName && (threadName = event.getThreadName()) != null) {
            map.put(THREAD_ATTR_NAME, threadName);
        }
        if (this.includeMDC && (mdc = event.getMDCPropertyMap()) != null && !mdc.isEmpty()) {
            map.put(MDC_ATTR_NAME, mdc);
        }
        if (this.includeLoggerName && (loggerName = event.getLoggerName()) != null) {
            map.put(LOGGER_ATTR_NAME, loggerName);
        }
        if (this.includeFormattedMessage && (msg = event.getFormattedMessage()) != null) {
            map.put(FORMATTED_MESSAGE_ATTR_NAME, msg);
        }
        if (this.includeMessage && (msg = event.getMessage()) != null) {
            map.put(MESSAGE_ATTR_NAME, msg);
        }
        if (this.includeContextName && (msg = event.getLoggerContextVO().getName()) != null) {
            map.put(CONTEXT_ATTR_NAME, msg);
        }
        if (this.includeException && (throwableProxy = event.getThrowableProxy()) != null && (ex = this.throwableProxyConverter.convert(event)) != null && !ex.equals("")) {
            map.put(EXCEPTION_ATTR_NAME, ex);
        }
        return map;
    }

    public boolean isIncludeLevel() {
        return this.includeLevel;
    }

    public void setIncludeLevel(boolean includeLevel) {
        this.includeLevel = includeLevel;
    }

    public boolean isIncludeLoggerName() {
        return this.includeLoggerName;
    }

    public void setIncludeLoggerName(boolean includeLoggerName) {
        this.includeLoggerName = includeLoggerName;
    }

    public boolean isIncludeFormattedMessage() {
        return this.includeFormattedMessage;
    }

    public void setIncludeFormattedMessage(boolean includeFormattedMessage) {
        this.includeFormattedMessage = includeFormattedMessage;
    }

    public boolean isIncludeMessage() {
        return this.includeMessage;
    }

    public void setIncludeMessage(boolean includeMessage) {
        this.includeMessage = includeMessage;
    }

    public boolean isIncludeMDC() {
        return this.includeMDC;
    }

    public void setIncludeMDC(boolean includeMDC) {
        this.includeMDC = includeMDC;
    }

    public boolean isIncludeThreadName() {
        return this.includeThreadName;
    }

    public void setIncludeThreadName(boolean includeThreadName) {
        this.includeThreadName = includeThreadName;
    }

    public boolean isIncludeException() {
        return this.includeException;
    }

    public void setIncludeException(boolean includeException) {
        this.includeException = includeException;
    }

    public boolean isIncludeContextName() {
        return this.includeContextName;
    }

    public void setIncludeContextName(boolean includeContextName) {
        this.includeContextName = includeContextName;
    }
}

