/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.cal10n.verifier;

import ch.qos.cal10n.util.AnnotationExtractor;
import ch.qos.cal10n.verifier.MessageKeyVerifierBase;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageKeyVerifier
extends MessageKeyVerifierBase {
    final Class<? extends Enum<?>> enumClass;

    public MessageKeyVerifier(Class<? extends Enum<?>> enumClass) {
        super(enumClass.getName(), new AnnotationExtractor(enumClass));
        this.enumClass = enumClass;
    }

    public MessageKeyVerifier(String enumTypeAsStr) {
        this(MessageKeyVerifier.buildEnumClass(enumTypeAsStr));
    }

    static Class<? extends Enum<?>> buildEnumClass(String enumClassAsStr) {
        String errMsg = "Failed to find enum class [" + enumClassAsStr + "]";
        try {
            return Class.forName(enumClassAsStr);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(errMsg, e);
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException(errMsg, e);
        }
    }

    @Override
    protected List<String> extractKeysInEnum() {
        Enum<?>[] enumArray;
        ArrayList<String> enumKeyList = new ArrayList<String>();
        for (Enum<?> e : enumArray = this.enumClass.getEnumConstants()) {
            enumKeyList.add(e.toString());
        }
        return enumKeyList;
    }
}

